-- Adminer 4.3.1 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `bets`;
CREATE TABLE `bets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `game_id` int(10) unsigned DEFAULT NULL,
  `place` int(32) NOT NULL DEFAULT '0',
  `items` text COLLATE utf8_unicode_ci NOT NULL,
  `itemsCount` int(11) NOT NULL,
  `price` double(8,2) NOT NULL,
  `from` int(11) NOT NULL,
  `to` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `bets_double`;
CREATE TABLE `bets_double` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `game_id` int(10) unsigned DEFAULT NULL,
  `itemsCount` int(11) NOT NULL,
  `price` int(36) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bet_num` int(11) NOT NULL,
  `bet_color` int(11) NOT NULL,
  `avatar` text COLLATE utf8_unicode_ci NOT NULL,
  `steamid64` text COLLATE utf8_unicode_ci NOT NULL,
  `username` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bets_user_id_foreign` (`user_id`),
  KEY `bets_game_id_foreign` (`game_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sitename` varchar(255) NOT NULL,
  `socket_ip` varchar(50) NOT NULL,
  `keywords` text NOT NULL,
  `description` text NOT NULL,
  `usd` double(8,2) NOT NULL DEFAULT '0.00',
  `online` varchar(255) NOT NULL,
  `curs` double(8,2) NOT NULL DEFAULT '0.00',
  `usd_2` double(8,2) NOT NULL DEFAULT '0.00',
  `curs_2` varchar(255) NOT NULL DEFAULT '1',
  `min_dep_sum` int(11) NOT NULL,
  `steamapikey` varchar(255) NOT NULL,
  `mrh_ID` varchar(255) NOT NULL,
  `order_id` varchar(255) NOT NULL DEFAULT '1',
  `mrh_secret1` varchar(255) NOT NULL,
  `mrh_secret2` varchar(255) NOT NULL,
  `privatekey` varchar(255) NOT NULL,
  `publickey` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `config` (`id`, `sitename`, `socket_ip`, `keywords`, `description`, `usd`, `online`, `curs`, `usd_2`, `curs_2`, `min_dep_sum`, `steamapikey`, `mrh_ID`, `order_id`, `mrh_secret1`, `mrh_secret2`, `privatekey`, `publickey`) VALUES
(1,	'1',	'1',	'1',	'1',	0.00,	'1',	0.00,	0.00,	'1',	1,	'1',	'1',	'1',	'1',	'1',	'1',	'1');

DROP TABLE IF EXISTS `csgotms`;
CREATE TABLE `csgotms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ui_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `market_hash_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `classid` int(11) NOT NULL,
  `instanceid` int(11) NOT NULL,
  `price` double(8,0) NOT NULL,
  `rarity` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `games`;
CREATE TABLE `games` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `chance` int(11) NOT NULL DEFAULT '0',
  `winner_id` int(10) unsigned DEFAULT NULL,
  `winTicket` int(10) unsigned DEFAULT NULL,
  `status` int(11) NOT NULL,
  `itemsCount` int(11) NOT NULL,
  `price` double(8,2) NOT NULL,
  `items` text COLLATE utf8_unicode_ci NOT NULL,
  `won_items` text COLLATE utf8_unicode_ci NOT NULL,
  `commission_items` text COLLATE utf8_unicode_ci NOT NULL,
  `started_at` timestamp NULL DEFAULT NULL,
  `finished_at` timestamp NULL DEFAULT NULL,
  `status_prize` int(11) NOT NULL,
  `rand_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `commission_price` double(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `games` (`id`, `chance`, `winner_id`, `winTicket`, `status`, `itemsCount`, `price`, `items`, `won_items`, `commission_items`, `started_at`, `finished_at`, `status_prize`, `rand_number`, `commission_price`, `created_at`, `updated_at`) VALUES
(1,	0,	NULL,	NULL,	0,	0,	0.00,	'',	'',	'',	NULL,	NULL,	0,	'0.559619182504555735',	0.00,	'2017-06-29 22:35:32',	'2017-06-29 22:35:32');


DROP TABLE IF EXISTS `games_double`;
CREATE TABLE `games_double` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `price_0` int(255) NOT NULL,
  `price_1` int(255) NOT NULL,
  `price_2` int(255) NOT NULL,
  `win_num` int(10) DEFAULT NULL,
  `won_const` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `finished_at` timestamp NULL DEFAULT NULL,
  `wobble` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `games_winner_id_foreign` (`win_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `games_double` (`id`, `price_0`, `price_1`, `price_2`, `win_num`, `won_const`, `status`, `created_at`, `updated_at`, `finished_at`, `wobble`) VALUES
(1,	0,	0,	0,	NULL,	0,	0,	'2017-06-30 02:23:25',	'2017-06-30 02:23:25',	NULL,	NULL),
(2,	0,	0,	0,	2,	1,	3,	'2017-10-23 20:57:41',	'2017-10-23 20:58:13',	'2017-10-23 20:58:13',	'0.956535268857402456'),
(3,	0,	0,	0,	NULL,	0,	0,	'2017-10-23 20:58:23',	'2017-10-23 20:58:23',	NULL,	NULL);

DROP TABLE IF EXISTS `giveaway`;
CREATE TABLE `giveaway` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `max_user` int(10) NOT NULL,
  `items` text NOT NULL,
  `finished_at` timestamp NULL DEFAULT NULL,
  `winner_id` int(10) unsigned DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `giveaway` (`id`, `max_user`, `items`, `finished_at`, `winner_id`, `status`, `created_at`, `updated_at`) VALUES
(9,	20,	'[{\"id\":9,\"name\":\"\\u0417\\u0430\\u043f\\u0435\\u0447\\u0430\\u0442\\u0430\\u043d\\u043d\\u044b\\u0439 \\u0433\\u0440\\u0430\\u0444\\u0444\\u0438\\u0442\\u0438 | GODSENT | \\u0410\\u0442\\u043b\\u0430\\u043d\\u0442\\u0430 2017\",\"classid\":\"2135301540\",\"inventoryId\":\"\",\"rarity\":\"\\u0432\\u044b\\u0441\\u0448\\u0435\\u0433\\u043e \\u043a\\u043b\\u0430\\u0441\\u0441\\u0430\",\"type\":\"\\u0413\\u0440\\u0430\\u0444\\u0444\\u0438\\u0442\\u0438\",\"status\":0,\"price\":14}]',	'2017-05-29 01:37:11',	1667,	4,	'2017-05-28 19:38:27',	'2017-05-29 01:37:11'),
(10,	24,	'[{\"id\":14,\"name\":\"P90 | \\u041c\\u0440\\u0430\\u043a\",\"classid\":\"1934416372\",\"inventoryId\":\"\",\"rarity\":\"\\u0410\\u0440\\u043c\\u0435\\u0439\\u0441\\u043a\\u043e\\u0435 \\u043a\\u0430\\u0447\\u0435\\u0441\\u0442\\u0432\\u043e\",\"type\":\"\\u041f\\u0438\\u0441\\u0442\\u043e\\u043b\\u0435\\u0442-\\u043f\\u0443\\u043b\\u0435\\u043c\\u0451\\u0442\",\"status\":0,\"price\":18.95}]',	'2017-05-29 10:21:55',	1724,	4,	'2017-05-29 01:37:11',	'2017-05-29 10:21:55'),
(11,	41,	'[{\"id\":13,\"name\":\"AK-47 | \\u042d\\u043b\\u0438\\u0442\\u043d\\u043e\\u0435 \\u0441\\u043d\\u0430\\u0440\\u044f\\u0436\\u0435\\u043d\\u0438\\u0435\",\"classid\":\"937243428\",\"inventoryId\":\"\",\"rarity\":\"\\u0410\\u0440\\u043c\\u0435\\u0439\\u0441\\u043a\\u043e\\u0435 \\u043a\\u0430\\u0447\\u0435\\u0441\\u0442\\u0432\\u043e\",\"type\":\"\\u0412\\u0438\\u043d\\u0442\\u043e\\u0432\\u043a\\u0430\",\"status\":0,\"price\":38.64}]',	'2017-05-29 18:10:41',	1836,	4,	'2017-05-29 10:21:55',	'2017-05-29 18:10:41'),
(12,	28,	'[{\"id\":12,\"name\":\"SSG 08 | \\u041a\\u0438\\u0441\\u043b\\u043e\\u0442\\u043d\\u044b\\u0439 \\u0433\\u0440\\u0430\\u0434\\u0438\\u0435\\u043d\\u0442\",\"classid\":\"310776737\",\"inventoryId\":\"\",\"rarity\":\"\\u0410\\u0440\\u043c\\u0435\\u0439\\u0441\\u043a\\u043e\\u0435 \\u043a\\u0430\\u0447\\u0435\\u0441\\u0442\\u0432\\u043e\",\"type\":\"\\u0421\\u043d\\u0430\\u0439\\u043f\\u0435\\u0440\\u0441\\u043a\\u0430\\u044f \\u0432\\u0438\\u043d\\u0442\\u043e\\u0432\\u043a\\u0430\",\"status\":0,\"price\":24.05}]',	'2017-05-30 08:01:43',	1051,	4,	'2017-05-29 18:10:41',	'2017-05-30 08:01:43'),
(13,	68,	'[{\"id\":11,\"name\":\"AWP | \\u0411\\u043e\\u0433 \\u0447\\u0435\\u0440\\u0432\\u0435\\u0439\",\"classid\":\"937244168\",\"inventoryId\":\"\",\"rarity\":\"\\u0417\\u0430\\u043f\\u0440\\u0435\\u0449\\u0435\\u043d\\u043d\\u043e\\u0435\",\"type\":\"\\u0421\\u043d\\u0430\\u0439\\u043f\\u0435\\u0440\\u0441\\u043a\\u0430\\u044f \\u0432\\u0438\\u043d\\u0442\\u043e\\u0432\\u043a\\u0430\",\"status\":0,\"price\":63.32}]',	'2017-06-01 12:08:22',	2178,	4,	'2017-05-30 08:01:43',	'2017-06-01 12:08:22'),
(14,	21,	'[{\"id\":10,\"name\":\"\\u0417\\u0430\\u043f\\u0435\\u0447\\u0430\\u0442\\u0430\\u043d\\u043d\\u044b\\u0439 \\u0433\\u0440\\u0430\\u0444\\u0444\\u0438\\u0442\\u0438 | GODSENT | \\u0410\\u0442\\u043b\\u0430\\u043d\\u0442\\u0430 2017\",\"classid\":\"2135301540\",\"inventoryId\":\"\",\"rarity\":\"\\u0432\\u044b\\u0441\\u0448\\u0435\\u0433\\u043e \\u043a\\u043b\\u0430\\u0441\\u0441\\u0430\",\"type\":\"\\u0413\\u0440\\u0430\\u0444\\u0444\\u0438\\u0442\\u0438\",\"status\":0,\"price\":14}]',	'2017-06-01 17:00:51',	1155,	4,	'2017-06-01 12:08:22',	'2017-06-01 17:00:51'),
(15,	18,	'[{\"id\":8,\"name\":\"\\u0417\\u0430\\u043f\\u0435\\u0447\\u0430\\u0442\\u0430\\u043d\\u043d\\u044b\\u0439 \\u0433\\u0440\\u0430\\u0444\\u0444\\u0438\\u0442\\u0438 | GODSENT | \\u0410\\u0442\\u043b\\u0430\\u043d\\u0442\\u0430 2017\",\"classid\":\"2135301540\",\"inventoryId\":\"\",\"rarity\":\"\\u0432\\u044b\\u0441\\u0448\\u0435\\u0433\\u043e \\u043a\\u043b\\u0430\\u0441\\u0441\\u0430\",\"type\":\"\\u0413\\u0440\\u0430\\u0444\\u0444\\u0438\\u0442\\u0438\",\"status\":0,\"price\":14}]',	'2017-06-01 21:51:42',	2538,	4,	'2017-06-01 17:00:51',	'2017-06-01 21:51:42'),
(16,	7,	'[{\"id\":18,\"name\":\"\\u041a\\u0435\\u0439\\u0441 \\u043e\\u043f\\u0435\\u0440\\u0430\\u0446\\u0438\\u0438 \\u00ab\\u0414\\u0438\\u043a\\u043e\\u0435 \\u043f\\u043b\\u0430\\u043c\\u044f\\u00bb\",\"classid\":\"1544067968\",\"inventoryId\":\"\",\"rarity\":\"\\u0431\\u0430\\u0437\\u043e\\u0432\\u043e\\u0433\\u043e \\u043a\\u043b\\u0430\\u0441\\u0441\\u0430\",\"type\":\"\\u041a\\u043e\\u043d\\u0442\\u0435\\u0439\\u043d\\u0435\\u0440\",\"status\":0,\"price\":0.28}]',	'2017-06-02 07:59:49',	1859,	4,	'2017-06-01 21:51:42',	'2017-06-02 07:59:49'),
(17,	5,	'[{\"id\":17,\"name\":\"\\u0425\\u0440\\u043e\\u043c\\u0438\\u0440\\u043e\\u0432\\u0430\\u043d\\u043d\\u044b\\u0439 \\u043a\\u0435\\u0439\\u0441 #3\",\"classid\":\"1690096482\",\"inventoryId\":\"\",\"rarity\":\"\\u0431\\u0430\\u0437\\u043e\\u0432\\u043e\\u0433\\u043e \\u043a\\u043b\\u0430\\u0441\\u0441\\u0430\",\"type\":\"\\u041a\\u043e\\u043d\\u0442\\u0435\\u0439\\u043d\\u0435\\u0440\",\"status\":0,\"price\":0.28}]',	'2017-06-02 08:55:43',	1859,	4,	'2017-06-02 07:59:49',	'2017-06-02 08:55:43'),
(18,	166,	'[{\"id\":16,\"name\":\"\\u041a\\u043b\\u044e\\u0447 \\u043e\\u0442 \\u043a\\u0435\\u0439\\u0441\\u0430 CS:GO\",\"classid\":\"186150629\",\"inventoryId\":\"\",\"rarity\":\"\\u0431\\u0430\\u0437\\u043e\\u0432\\u043e\\u0433\\u043e \\u043a\\u043b\\u0430\\u0441\\u0441\\u0430\",\"type\":\"\\u041a\\u043b\\u044e\\u0447\",\"status\":0,\"price\":159.11}]',	'2017-06-20 08:55:22',	301,	4,	'2017-06-02 08:55:43',	'2017-06-20 08:55:22'),
(19,	84,	'[{\"id\":15,\"name\":\"StatTrak\\u2122 Five-SeveN | \\u041a\\u0430\\u043c\\u0438\",\"classid\":\"310778371\",\"inventoryId\":\"\",\"rarity\":\"\\u0410\\u0440\\u043c\\u0435\\u0439\\u0441\\u043a\\u043e\\u0435 \\u043a\\u0430\\u0447\\u0435\\u0441\\u0442\\u0432\\u043e\",\"type\":\"\\u041f\\u0438\\u0441\\u0442\\u043e\\u043b\\u0435\\u0442\",\"status\":0,\"price\":83.45}]',	'2017-06-27 10:55:47',	258,	4,	'2017-06-20 08:55:22',	'2017-06-27 10:55:47'),
(20,	23,	'[{\"id\":19,\"name\":\"Sawed-Off | \\u041f\\u044b\\u043b\\u044c\\u043d\\u0438\\u043a\",\"classid\":\"519977859\",\"inventoryId\":\"\",\"rarity\":\"\\u041f\\u0440\\u043e\\u043c\\u044b\\u0448\\u043b\\u0435\\u043d\\u043d\\u043e\\u0435 \\u043a\\u0430\\u0447\\u0435\\u0441\\u0442\\u0432\\u043e\",\"type\":\"\\u0414\\u0440\\u043e\\u0431\\u043e\\u0432\\u0438\\u043a\",\"status\":0,\"price\":15.71}]',	'2017-06-29 09:06:59',	4485,	4,	'2017-06-27 10:55:47',	'2017-06-29 09:06:59'),
(21,	31,	'[{\"id\":20,\"name\":\"M4A1-S | \\u0411\\u0440\\u0438\\u0444\\u0438\\u043d\\u0433\",\"classid\":\"2327620492\",\"inventoryId\":\"\",\"rarity\":\"\\u0410\\u0440\\u043c\\u0435\\u0439\\u0441\\u043a\\u043e\\u0435 \\u043a\\u0430\\u0447\\u0435\\u0441\\u0442\\u0432\\u043e\",\"type\":\"\\u0412\\u0438\\u043d\\u0442\\u043e\\u0432\\u043a\\u0430\",\"status\":0,\"price\":29.58}]',	NULL,	NULL,	4,	'2017-06-29 09:06:59',	'2017-06-29 09:07:02');

DROP TABLE IF EXISTS `giveaway_items`;
CREATE TABLE `giveaway_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `classid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inventoryId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `rarity` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `price` double(8,2) NOT NULL,
  PRIMARY KEY (`id`,`rarity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `giveaway_items` (`id`, `name`, `classid`, `inventoryId`, `rarity`, `type`, `status`, `price`) VALUES
(8,	'Запечатанный граффити | GODSENT | Атланта 2017',	'2135301540',	'',	'высшего класса',	'Граффити',	3,	14.00),
(9,	'Запечатанный граффити | GODSENT | Атланта 2017',	'2135301540',	'',	'высшего класса',	'Граффити',	3,	14.00),
(10,	'Запечатанный граффити | GODSENT | Атланта 2017',	'2135301540',	'',	'высшего класса',	'Граффити',	3,	14.00),
(11,	'AWP | Бог червей',	'937244168',	'',	'Запрещенное',	'Снайперская винтовка',	3,	63.32),
(12,	'SSG 08 | Кислотный градиент',	'310776737',	'',	'Армейское качество',	'Снайперская винтовка',	3,	24.05),
(13,	'AK-47 | Элитное снаряжение',	'937243428',	'',	'Армейское качество',	'Винтовка',	3,	38.64),
(14,	'P90 | Мрак',	'1934416372',	'',	'Армейское качество',	'Пистолет-пулемёт',	3,	18.95),
(15,	'StatTrak™ Five-SeveN | Ками',	'310778371',	'',	'Армейское качество',	'Пистолет',	3,	83.45),
(16,	'Ключ от кейса CS:GO',	'186150629',	'',	'базового класса',	'Ключ',	3,	159.11),
(17,	'Хромированный кейс #3',	'1690096482',	'',	'базового класса',	'Контейнер',	3,	0.28),
(18,	'Кейс операции «Дикое пламя»',	'1544067968',	'',	'базового класса',	'Контейнер',	3,	0.28),
(19,	'Sawed-Off | Пыльник',	'519977859',	'',	'Промышленное качество',	'Дробовик',	3,	15.71),
(20,	'M4A1-S | Брифинг',	'2327620492',	'',	'Армейское качество',	'Винтовка',	3,	29.58),
(21,	'Tec-9 | Трафарет',	'2316435980',	'',	'Армейское качество',	'Пистолет',	0,	12.24);

DROP TABLE IF EXISTS `giveaway_users`;
CREATE TABLE `giveaway_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `giveaway_id` int(10) NOT NULL,
  `user_id` int(10) NOT NULL,
  `num` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `giveaway_users` (`id`, `giveaway_id`, `user_id`, `num`) VALUES
(59,	9,	48,	1),
(60,	9,	711,	2),
(61,	9,	732,	3),
(62,	9,	622,	4),
(63,	9,	718,	5),
(64,	9,	303,	6),
(65,	9,	1662,	7),
(66,	9,	1668,	8),
(67,	9,	1667,	9),
(68,	9,	1671,	10),
(69,	9,	1677,	11),
(70,	9,	631,	12),
(71,	9,	1682,	13),
(72,	9,	1666,	14),
(73,	9,	776,	15),
(74,	9,	1179,	16),
(75,	9,	1694,	17),
(76,	9,	104,	18),
(77,	9,	525,	19),
(78,	9,	1707,	20),
(79,	10,	1707,	1),
(80,	10,	1596,	2),
(81,	10,	1711,	3),
(82,	10,	287,	4),
(83,	10,	1713,	5),
(84,	10,	1714,	6),
(85,	10,	1715,	7),
(86,	10,	1717,	8),
(87,	10,	776,	9),
(88,	10,	1724,	10),
(89,	10,	747,	11),
(90,	10,	1376,	12),
(91,	10,	1377,	13),
(92,	10,	1375,	14),
(93,	10,	771,	15),
(94,	10,	59,	16),
(95,	10,	1748,	17),
(96,	10,	732,	18),
(97,	10,	633,	19),
(98,	10,	667,	20),
(99,	10,	636,	21),
(100,	10,	1781,	22),
(101,	10,	721,	23),
(102,	10,	1794,	24),
(103,	11,	1800,	1),
(104,	11,	1807,	2),
(105,	11,	59,	3),
(106,	11,	622,	4),
(107,	11,	1818,	5),
(108,	11,	1824,	6),
(109,	11,	1202,	7),
(110,	11,	1830,	8),
(111,	11,	1832,	9),
(112,	11,	1833,	10),
(113,	11,	1834,	11),
(114,	11,	636,	12),
(115,	11,	747,	13),
(116,	11,	1846,	14),
(117,	11,	1836,	15),
(118,	11,	1589,	16),
(119,	11,	1866,	17),
(120,	11,	1861,	18),
(121,	11,	1859,	19),
(122,	11,	1398,	20),
(123,	11,	1671,	21),
(124,	11,	633,	22),
(125,	11,	1131,	23),
(126,	11,	1888,	24),
(127,	11,	927,	25),
(128,	11,	1269,	26),
(129,	11,	1596,	27),
(130,	11,	1907,	28),
(131,	11,	19,	29),
(132,	11,	1908,	30),
(133,	11,	782,	31),
(134,	11,	1919,	32),
(135,	11,	1560,	33),
(136,	11,	1920,	34),
(137,	11,	1931,	35),
(138,	11,	718,	36),
(139,	11,	1942,	37),
(140,	11,	1940,	38),
(141,	11,	1909,	39),
(142,	11,	1946,	40),
(143,	11,	1949,	41),
(144,	12,	1949,	1),
(145,	12,	59,	2),
(146,	12,	1051,	3),
(147,	12,	1859,	4),
(148,	12,	1952,	5),
(149,	12,	636,	6),
(150,	12,	633,	7),
(151,	12,	718,	8),
(152,	12,	1616,	9),
(153,	12,	721,	10),
(154,	12,	1968,	11),
(155,	12,	1970,	12),
(156,	12,	106,	13),
(157,	12,	1003,	14),
(158,	12,	732,	15),
(159,	12,	1942,	16),
(160,	12,	130,	17),
(161,	12,	1990,	18),
(162,	12,	1991,	19),
(163,	12,	525,	20),
(164,	12,	776,	21),
(165,	12,	287,	22),
(166,	12,	1931,	23),
(167,	12,	926,	24),
(168,	12,	2005,	25),
(169,	12,	1953,	26),
(170,	12,	1872,	27),
(171,	12,	717,	28),
(172,	13,	717,	1),
(173,	13,	667,	2),
(174,	13,	1051,	3),
(175,	13,	1398,	4),
(176,	13,	927,	5),
(177,	13,	195,	6),
(178,	13,	432,	7),
(179,	13,	1859,	8),
(180,	13,	671,	9),
(181,	13,	19,	10),
(182,	13,	1970,	11),
(183,	13,	1202,	12),
(184,	13,	1099,	13),
(185,	13,	1372,	14),
(186,	13,	2074,	15),
(187,	13,	287,	16),
(188,	13,	2076,	17),
(189,	13,	1308,	18),
(190,	13,	1953,	19),
(191,	13,	747,	20),
(192,	13,	821,	21),
(193,	13,	104,	22),
(194,	13,	2107,	23),
(195,	13,	771,	24),
(196,	13,	216,	25),
(197,	13,	2118,	26),
(198,	13,	1694,	27),
(199,	13,	450,	28),
(200,	13,	633,	29),
(201,	13,	636,	30),
(202,	13,	622,	31),
(203,	13,	718,	32),
(204,	13,	453,	33),
(205,	13,	721,	34),
(206,	13,	776,	35),
(207,	13,	2172,	36),
(208,	13,	2178,	37),
(209,	13,	2191,	38),
(210,	13,	1968,	39),
(211,	13,	2197,	40),
(212,	13,	2208,	41),
(213,	13,	2209,	42),
(214,	13,	2214,	43),
(215,	13,	2233,	44),
(216,	13,	2245,	45),
(217,	13,	2247,	46),
(218,	13,	2254,	47),
(219,	13,	719,	48),
(220,	13,	303,	49),
(221,	13,	2268,	50),
(222,	13,	2269,	51),
(223,	13,	995,	52),
(224,	13,	732,	53),
(225,	13,	779,	54),
(226,	13,	2154,	55),
(227,	13,	2300,	56),
(228,	13,	1227,	57),
(229,	13,	1222,	58),
(230,	13,	1218,	59),
(231,	13,	1216,	60),
(232,	13,	2161,	61),
(233,	13,	2317,	62),
(234,	13,	152,	63),
(235,	13,	2334,	64),
(236,	13,	2340,	65),
(237,	13,	2351,	66),
(238,	13,	1724,	67),
(239,	13,	2367,	68),
(240,	14,	2367,	1),
(241,	14,	1859,	2),
(242,	14,	1206,	3),
(243,	14,	2191,	4),
(244,	14,	2400,	5),
(245,	14,	2424,	6),
(246,	14,	1372,	7),
(247,	14,	2443,	8),
(248,	14,	19,	9),
(249,	14,	821,	10),
(250,	14,	747,	11),
(251,	14,	717,	12),
(252,	14,	1155,	13),
(253,	14,	671,	14),
(254,	14,	425,	15),
(255,	14,	2472,	16),
(256,	14,	2466,	17),
(257,	14,	776,	18),
(258,	14,	771,	19),
(259,	14,	2486,	20),
(260,	14,	2490,	21),
(261,	15,	2486,	1),
(262,	15,	19,	2),
(263,	15,	2490,	3),
(264,	15,	2498,	4),
(265,	15,	1155,	5),
(266,	15,	2503,	6),
(267,	15,	1859,	7),
(268,	15,	821,	8),
(269,	15,	2513,	9),
(270,	15,	129,	10),
(271,	15,	719,	11),
(272,	15,	771,	12),
(273,	15,	732,	13),
(274,	15,	2531,	14),
(275,	15,	2536,	15),
(276,	15,	2538,	16),
(277,	15,	2542,	17),
(278,	15,	1398,	18),
(279,	16,	1398,	1),
(280,	16,	2300,	2),
(281,	16,	17,	3),
(282,	16,	1859,	4),
(283,	16,	48,	5),
(284,	16,	2531,	6),
(285,	16,	2565,	7),
(286,	17,	2565,	1),
(287,	17,	1859,	2),
(288,	17,	1003,	3),
(289,	17,	636,	4),
(290,	17,	2568,	5),
(291,	18,	2568,	1),
(292,	18,	1859,	2),
(293,	18,	2565,	3),
(294,	18,	622,	4),
(295,	18,	2580,	5),
(296,	18,	2587,	6),
(297,	18,	2588,	7),
(298,	18,	732,	8),
(299,	18,	2503,	9),
(300,	18,	2107,	10),
(301,	18,	2531,	11),
(302,	18,	2486,	12),
(303,	18,	2490,	13),
(304,	18,	2625,	14),
(305,	18,	2497,	15),
(306,	18,	2635,	16),
(307,	18,	2538,	17),
(308,	18,	1003,	18),
(309,	18,	432,	19),
(310,	18,	2636,	20),
(311,	18,	821,	21),
(312,	18,	216,	22),
(313,	18,	1246,	23),
(314,	18,	146,	24),
(315,	18,	542,	25),
(316,	18,	747,	26),
(317,	18,	2613,	27),
(318,	18,	2678,	28),
(319,	18,	2069,	29),
(320,	18,	1398,	30),
(321,	18,	287,	31),
(322,	18,	2696,	32),
(323,	18,	2701,	33),
(324,	18,	2712,	34),
(325,	18,	2748,	35),
(326,	18,	717,	36),
(327,	18,	130,	37),
(328,	18,	19,	38),
(329,	18,	2782,	39),
(330,	18,	2785,	40),
(331,	18,	1875,	41),
(332,	18,	2807,	42),
(333,	18,	2813,	43),
(334,	18,	2823,	44),
(335,	18,	923,	45),
(336,	18,	2836,	46),
(337,	18,	2838,	47),
(338,	18,	776,	48),
(339,	18,	1024,	49),
(340,	18,	2870,	50),
(341,	18,	2883,	51),
(342,	18,	129,	52),
(343,	18,	2884,	53),
(344,	18,	2893,	54),
(345,	18,	2928,	55),
(346,	18,	2944,	56),
(347,	18,	1218,	57),
(348,	18,	1030,	58),
(349,	18,	2998,	59),
(350,	18,	671,	60),
(351,	18,	3010,	61),
(352,	18,	416,	62),
(353,	18,	771,	63),
(354,	18,	3022,	64),
(355,	18,	718,	65),
(356,	18,	450,	66),
(357,	18,	1202,	67),
(358,	18,	3064,	68),
(359,	18,	2367,	69),
(360,	18,	3070,	70),
(361,	18,	3073,	71),
(362,	18,	1206,	72),
(363,	18,	3114,	73),
(364,	18,	3128,	74),
(365,	18,	3153,	75),
(366,	18,	303,	76),
(367,	18,	3164,	77),
(368,	18,	3133,	78),
(369,	18,	2191,	79),
(370,	18,	1908,	80),
(371,	18,	434,	81),
(372,	18,	3213,	82),
(373,	18,	3259,	83),
(374,	18,	1593,	84),
(375,	18,	3277,	85),
(376,	18,	833,	86),
(377,	18,	3281,	87),
(378,	18,	3313,	88),
(379,	18,	927,	89),
(380,	18,	63,	90),
(381,	18,	2208,	91),
(382,	18,	3337,	92),
(383,	18,	12,	93),
(384,	18,	195,	94),
(385,	18,	3349,	95),
(386,	18,	3341,	96),
(387,	18,	3354,	97),
(388,	18,	2619,	98),
(389,	18,	3363,	99),
(390,	18,	3370,	100),
(391,	18,	3375,	101),
(392,	18,	3065,	102),
(393,	18,	3399,	103),
(394,	18,	65,	104),
(395,	18,	3407,	105),
(396,	18,	3426,	106),
(397,	18,	3443,	107),
(398,	18,	3480,	108),
(399,	18,	3481,	109),
(400,	18,	3562,	110),
(401,	18,	3262,	111),
(402,	18,	3419,	112),
(403,	18,	3320,	113),
(404,	18,	118,	114),
(405,	18,	1179,	115),
(406,	18,	711,	116),
(407,	18,	3620,	117),
(408,	18,	3624,	118),
(409,	18,	3650,	119),
(410,	18,	184,	120),
(411,	18,	3664,	121),
(412,	18,	3663,	122),
(413,	18,	3668,	123),
(414,	18,	3244,	124),
(415,	18,	3694,	125),
(416,	18,	3722,	126),
(417,	18,	3723,	127),
(418,	18,	3725,	128),
(419,	18,	152,	129),
(420,	18,	3730,	130),
(421,	18,	3746,	131),
(422,	18,	2149,	132),
(423,	18,	3747,	133),
(424,	18,	3767,	134),
(425,	18,	3701,	135),
(426,	18,	3813,	136),
(427,	18,	3823,	137),
(428,	18,	719,	138),
(429,	18,	1890,	139),
(430,	18,	3714,	140),
(431,	18,	3913,	141),
(432,	18,	301,	142),
(433,	18,	3952,	143),
(434,	18,	3957,	144),
(435,	18,	3708,	145),
(436,	18,	4015,	146),
(437,	18,	3863,	147),
(438,	18,	3476,	148),
(439,	18,	3338,	149),
(440,	18,	4038,	150),
(441,	18,	4040,	151),
(442,	18,	4062,	152),
(443,	18,	2727,	153),
(444,	18,	4099,	154),
(445,	18,	4112,	155),
(446,	18,	1818,	156),
(447,	18,	4117,	157),
(448,	18,	4123,	158),
(449,	18,	4127,	159),
(450,	18,	4128,	160),
(451,	18,	4130,	161),
(452,	18,	3769,	162),
(453,	18,	4160,	163),
(454,	18,	4097,	164),
(455,	18,	2960,	165),
(456,	18,	4190,	166),
(457,	19,	4112,	1),
(458,	19,	4194,	2),
(459,	19,	434,	3),
(460,	19,	3022,	4),
(461,	19,	2486,	5),
(462,	19,	2836,	6),
(463,	19,	717,	7),
(464,	19,	4218,	8),
(465,	19,	821,	9),
(466,	19,	4198,	10),
(467,	19,	63,	11),
(468,	19,	130,	12),
(469,	19,	288,	13),
(470,	19,	432,	14),
(471,	19,	4241,	15),
(472,	19,	1024,	16),
(473,	19,	3320,	17),
(474,	19,	3668,	18),
(475,	19,	4252,	19),
(476,	19,	4255,	20),
(477,	19,	4261,	21),
(478,	19,	4040,	22),
(479,	19,	4286,	23),
(480,	19,	4293,	24),
(481,	19,	195,	25),
(482,	19,	4302,	26),
(483,	19,	1246,	27),
(484,	19,	671,	28),
(485,	19,	986,	29),
(486,	19,	4276,	30),
(487,	19,	4333,	31),
(488,	19,	4335,	32),
(489,	19,	732,	33),
(490,	19,	711,	34),
(491,	19,	152,	35),
(492,	19,	2538,	36),
(493,	19,	4327,	37),
(494,	19,	622,	38),
(495,	19,	3244,	39),
(496,	19,	1754,	40),
(497,	19,	3769,	41),
(498,	19,	65,	42),
(499,	19,	3810,	43),
(500,	19,	4432,	44),
(501,	19,	4128,	45),
(502,	19,	4453,	46),
(503,	19,	4451,	47),
(504,	19,	4015,	48),
(505,	19,	2235,	49),
(506,	19,	4470,	50),
(507,	19,	3722,	51),
(508,	19,	4096,	52),
(509,	19,	258,	53),
(510,	19,	4485,	54),
(511,	19,	3315,	55),
(512,	19,	4498,	56),
(513,	19,	19,	57),
(514,	19,	719,	58),
(515,	19,	4522,	59),
(516,	19,	4534,	60),
(517,	19,	88,	61),
(518,	19,	747,	62),
(519,	19,	4553,	63),
(520,	19,	4572,	64),
(521,	19,	4574,	65),
(522,	19,	3708,	66),
(523,	19,	4209,	67),
(524,	19,	4589,	68),
(525,	19,	4590,	69),
(526,	19,	4603,	70),
(527,	19,	1547,	71),
(528,	19,	4383,	72),
(529,	19,	4611,	73),
(530,	19,	4626,	74),
(531,	19,	3337,	75),
(532,	19,	4627,	76),
(533,	19,	1051,	77),
(534,	19,	1280,	78),
(535,	19,	3723,	79),
(536,	19,	4634,	80),
(537,	19,	4637,	81),
(538,	19,	712,	82),
(539,	19,	4642,	83),
(540,	19,	1106,	84),
(541,	20,	4112,	1),
(542,	20,	4635,	2),
(543,	20,	434,	3),
(544,	20,	821,	4),
(545,	20,	3837,	5),
(546,	20,	4485,	6),
(547,	20,	747,	7),
(548,	20,	3723,	8),
(549,	20,	4276,	9),
(550,	20,	3476,	10),
(551,	20,	1051,	11),
(552,	20,	4327,	12),
(553,	20,	711,	13),
(554,	20,	4096,	14),
(555,	20,	288,	15),
(556,	20,	4637,	16),
(557,	20,	4717,	17),
(558,	20,	416,	18),
(559,	20,	3722,	19),
(560,	20,	4725,	20),
(561,	20,	4734,	21),
(562,	20,	3022,	22),
(563,	20,	1280,	23),
(564,	21,	1280,	1),
(565,	21,	4697,	2),
(566,	21,	17,	3),
(567,	21,	4635,	4),
(568,	21,	450,	5),
(569,	21,	4746,	6),
(570,	21,	4327,	7),
(571,	21,	65,	8),
(572,	21,	4644,	9),
(573,	21,	434,	10),
(574,	21,	821,	11),
(575,	21,	4096,	12),
(576,	21,	3320,	13),
(577,	21,	19,	14);

DROP TABLE IF EXISTS `items`;
CREATE TABLE `items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `market_hash_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `classid` int(11) NOT NULL,
  `rarity` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `price` double(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `payments`;
CREATE TABLE `payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `secret` varchar(255) NOT NULL,
  `merchant_id` varchar(255) NOT NULL,
  `order_id` varchar(255) NOT NULL,
  `sum` double(20,2) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `payments_skins`;
CREATE TABLE `payments_skins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `orderid` varchar(255) NOT NULL,
  `userid` varchar(255) NOT NULL,
  `sign` varchar(255) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `refers`;
CREATE TABLE `refers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usera` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `userb` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `shop`;
CREATE TABLE `shop` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `classid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inventoryId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `steamid64` text COLLATE utf8_unicode_ci NOT NULL,
  `rarity` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `quality` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `buyer_id` int(10) unsigned DEFAULT NULL,
  `status` int(11) NOT NULL,
  `steam_price` double(8,2) NOT NULL,
  `price` double(8,2) NOT NULL,
  `buy_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`,`rarity`),
  KEY `shop_buyer_id_foreign` (`buyer_id`),
  CONSTRAINT `shop_buyer_id_foreign` FOREIGN KEY (`buyer_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `tickets`;
CREATE TABLE `tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `img` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `price` double(8,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `avatar` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `steamid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `steamid64` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `tradeban` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'none',
  `trade_link` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `accessToken` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `money` double(8,0) NOT NULL,
  `votes` int(11) NOT NULL,
  `is_admin` tinyint(1) NOT NULL,
  `is_moderator` tinyint(1) NOT NULL,
  `is_vip` tinyint(1) NOT NULL,
  `banchat` tinyint(1) NOT NULL,
  `refkode` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `refcount` int(11) NOT NULL,
  `refprofit` int(11) NOT NULL,
  `refstatus` int(11) NOT NULL,
  `remember_token` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bonus` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_steamid_unique` (`steamid`),
  UNIQUE KEY `users_steamid64_unique` (`steamid64`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `users` (`id`, `username`, `avatar`, `steamid`, `steamid64`, `tradeban`, `trade_link`, `accessToken`, `money`, `votes`, `is_admin`, `is_moderator`, `is_vip`, `banchat`, `refkode`, `refcount`, `refprofit`, `refstatus`, `remember_token`, `created_at`, `updated_at`, `bonus`) VALUES
(1,	'Алёнка',	'https://steamcdn-a.akamaihd.net/steamcommunity/public/images/avatars/d4/d4a9d173fd2bf839ddc9655de449f388fdfc3b23_full.jpg',	'STEAM_0:0:206307821',	'76561198372881370',	'none',	'',	'',	0,	0,	1,	0,	0,	0,	'CSGOPLAY',	0,	0,	0,	'xmTVjFEwmcPBBfgQpOZhzLG7ARweEYrGrXx3j0vmjq4uOfRUMZSwpikJFCwQ',	'2017-06-29 22:48:41',	'2017-06-29 22:48:41',	NULL),
(2,	'Twitch Uncle_Polly',	'https://steamcdn-a.akamaihd.net/steamcommunity/public/images/avatars/35/35cdd5126158753839809fbfbad52b0dfd32e070_full.jpg',	'STEAM_0:0:214552568',	'76561198389370864',	'none',	'',	'',	0,	0,	1,	0,	0,	0,	'',	0,	0,	0,	'dH6K1Sa8lOmMXp4EHltklfz8PboBM785VnSnl15JZpgYi7GUsBMMPSIIE5Rd',	'2017-06-29 23:00:18',	'2017-06-30 23:27:57',	NULL),
(3,	'ПETУCOCK ***',	'https://steamcdn-a.akamaihd.net/steamcommunity/public/images/avatars/a2/a2e07381fce61eba5604f0e4e71eb28c3f1bb6a9_full.jpg',	'STEAM_0:0:202357769',	'76561198364981266',	'none',	'',	'',	0,	0,	0,	0,	0,	0,	'',	0,	0,	0,	'8sDz10WSGyCfQ1ZV9U5zt7AZ4Vv587MK7ZuXgJlU0IoUlEOjQ1ddAulsut9A',	'2017-06-30 01:57:01',	'2017-06-30 01:57:02',	NULL),
(4,	'BlackM@ze#NS ***',	'https://steamcdn-a.akamaihd.net/steamcommunity/public/images/avatars/de/de7a23d0a29252ca1ebc2f7edb2f1ba26b5358d9_full.jpg',	'STEAM_0:0:204451588',	'76561198369168904',	'none',	'',	'',	0,	0,	1,	0,	0,	0,	'CS123',	0,	0,	0,	'8KU1sKYSlOJKOhM9KyEkJo6qMz2tnQQH06Khiw4I7mpgRg9ZRADAI14Vuukw',	'2017-07-01 01:15:47',	'2017-07-01 01:15:47',	NULL);

DROP TABLE IF EXISTS `winner_double`;
CREATE TABLE `winner_double` (
  `id` int(10) unsigned NOT NULL,
  `win_num` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `winner_tickets`;
CREATE TABLE `winner_tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `winnerticket` bigint(20) NOT NULL,
  `game_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- 2017-10-23 13:58:31
