<?php 

class Qiwi 
{
    protected $auth;
    
    private $errorMap = array(
    		5       => 'Неверный формат параметров запроса',
    		13      => 'Сервер занят, повторите запрос позже',
    		150     => 'Ошибка авторизации',
    		210     => 'Счет не найден',
    		215     => 'Счет с таким bill_id уже существует',
    		241     => 'Сумма слишком мала',
    		242     => 'Сумма слишком велика',
    		300     => 'Техническая ошибка, повторите запрос позже',
    		316     => 'Не удалось подключиться к Qiwi cерверу, сообщите администратору',
        1000    => 'Неизвестная ошибка протокола, сообщите администратору',
	  );
    
    public function __construct($auth) {
        $this->auth = $auth;
    }
    
    protected function init($url, $config, $method) {
        $headers = array(
            "Accept: application/json",
        );
        
        if (function_exists('ini_set')) {
          ini_set('arg_separator.output', "&");
        }
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($config));
        curl_setopt($ch, CURLOPT_POST, 1); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $this->auth['api_id'].':'.$this->auth['api_pass']);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        curl_close ($ch);

        return $result;
    }
    
    public function create($url, $config) {
        $request = $this->init($url, $config, 'PUT');
        return $request;
    }
    
    public function parseError($code = 0) {
        if ($code !== 0 && isset($this->errorMap[$code])) {
            return $this->errorMap[$code];
        } elseif ($code !== 0 && !isset($this->errorMap[$code])) {
            return $this->errorMap[1000];
        }
    }
}