<?

define('H', $_SERVER['DOCUMENT_ROOT'] . '/');
include_once H.'sys/inc/start.php';
include_once H.'sys/inc/sess.php';
include_once H.'sys/inc/settings.php';
include_once H.'sys/inc/db_connect.php';
include_once H.'sys/inc/ipua.php';
include_once H.'sys/inc/fnc.php';
include_once H.'sys/inc/adm_check.php';
include_once H.'sys/inc/user.php';
user_access('adm_mysql', null, 'index.php?'.SID);
adm_check(); 

/**
* Каталог конфигов платежных систем
*/
define('INI', $_SERVER['DOCUMENT_ROOT'] . '/sys/dat/payment/');

/**
* Каталог шаблонов платежных систем
*/
define('TPL', $_SERVER['DOCUMENT_ROOT'] . '/plugins/payment/tpl/');

/**
* Подключение классов
*/
require H.'plugins/payment/classes/Payment_Template.php';
require H.'plugins/payment/classes/Payment.php';

// Инициализация класса для работы
$payment = new Payment();

/**
* Включение/Отключение системы
*/
if (isset($_GET['status'])) {
  if (!isset($setPayment['error'])) {
    
    $setPayment = $payment->getSettings($_GET['identifier']);
    $setPayment['status'] = ($_GET['status'] == 1 ? 1 : 0);
    
    if (!isset($setPayment['error'])) {
      $payment->getSave($setPayment['identifier'], 'save', serialize($setPayment));
      
      $_SESSION['message'] = __('Параметры успешно приняты');
      header('Location: ?');
      exit;
    } else { 
      $err[] = $setPayment['error'];
    }
  } else {
    $err[] = $setPayment['error'];
  }
}

/**
* Удаление системы
*/
if (isset($_GET['act']) && $_GET['act'] == 'delete') {
  if (isset($_GET['identifier'])) {
    $setPayment = $payment->getSettings($_GET['identifier']);
    
    if (!isset($setPayment['error'])) {
      $delete = $payment->getSave($setPayment['identifier'], 'unlink');
      
      if (!isset($delete['error'])) {
        $_SESSION['message'] = __('Платежная система %s успешно удалена', $setPayment['name']);
        header('Location: ?func=' . $func);
        exit;
      } else {
        $err[] = $delete['error'];
      }
    } else {
      $err[] = $setPayment['error'];
    }
  }
}

/**
* Создание / Редактирование системы
*/
if (isset($_GET['act']) && ($_GET['act'] == 'create' || $_GET['act'] == 'edit')) {
  
  if (isset($_GET['identifier'])) {
    $setPayment = $payment->getSettings($_GET['identifier']);
    
    if (isset($_POST['save']) && !isset($setPayment['error'])) {
      foreach ($_POST AS $key => $value) {
        $setPayment['PAYMENT'][$key] = $value;
      } 
      
      $setPayment['save'] = 1;
      $setPayment['desc'] = htmlspecialchars($_POST['desc']);
      
      unset($setPayment['PAYMENT']['save'], $setPayment['NODAT'], $setPayment['url_desc'], $setPayment['url_help'], $setPayment['PAYMENT']['desc']); 
      
      $payment->getSave($setPayment['identifier'], 'save', serialize($setPayment));
      
      if (!isset($setPayment['error'])) {
        $_SESSION['message'] = __('Параметры успешно приняты');
        header('Location: ?func=' . $func);
        exit;
      } else {
        $err[] = $setPayment['error'];
      }
    } elseif (isset($setPayment['error'])) {
      $err[] = $setPayment['error'];
    }
  }
}

$set['title'] = __('Настройки платежных систем');
include_once H.'sys/inc/thead.php';
title();
aut();
err();

if (isset($_GET['act']) && ($_GET['act'] == 'create' || $_GET['act'] == 'edit')) {
  
  if (isset($_GET['identifier'])) {
    ?>
    <div class="alert" style="margin: 2px;">
    <?= __('Настроить параметры для выбранной платежной системы. Более подробную информацию, вы можете получить на сайте платежной системы %s', $setPayment['name'])?>.<br />
    <a target="_blank" href="<?= $setPayment['url']?>"><?= __('Cайт')?></a> | 
    <a target="_blank" href="<?= $setPayment['url_desc']?>"><?= __('Описание')?></a> | 
    <a target="_blank" href="<?= $setPayment['url_help']?>"><?= __('Документация')?></a>
    </div>
    
    <? if (isset($setPayment['NODAT']['install'])) { ?>

      <table class="table table-bordered" style="margin: 0;">
        <tr class="warning"><td class="text-center">#</td><td><b><?= __('Инструкция по настройке')?></b></td></tr>
        <? foreach ($setPayment['NODAT']['install'] AS $key => $value) { ?>
          <tr><td class="text-center">&diams;</td><td><?= __($value, $_SERVER['SERVER_NAME'])?></td></tr>
        <? } ?>
      </table>
      
    <? } ?>
    
    <div class="nav1">
      <form class="form-horizontal" action="?act=create&amp;identifier=<?= urlencode($_GET['identifier'])?>" method="POST">
        <?
        foreach($setPayment['PAYMENT'] AS $key => $value) {
          ?>
          <div class="control-group">
            <label class="control-label" for="<?= $key?>"><span class="on"><?= $key?></span></label>
            <div class="controls">
              <input type="text" id="<?= $key?>" name="<?= $key?>" value="<?= $value?>" />
            </div>
          </div>
          <?
        }
        ?>
      
        <div class="control-group">
          <label class="control-label" for="desc"><span class="on"><?= __('Описание системы')?></span></label>
          <div class="controls">
            <textarea id="desc" name="desc"><?= text($setPayment['desc'])?></textarea>
          </div>
        </div>
        
        <div class="control-group">
          <div class="controls">
            <button type="submit" name="save" value="0" class="btn btn-success"><?= __('Сохранить')?></button>
          </div>
        </div>
      </form>
    </div>
    
    <div class="foot">
    &laquo; <a href="<?= ($_GET['act'] == 'create' ? '?act=create' : '?')?>"><?= __('Назад')?></a>
    </div>
    <?
  } else {
    ?>
    <div class="alert" style="margin: 2px;">
    <?= __('Выбирите платежную систему из списка ниже.')?>
    </div>
    <?
    
    $list = $payment->getSystems('ini');
    $k_post = count($list);
    
    if ($k_post == 0) {
      ?>
      <div class="alert" style="margin: 2px;"><?= __('Список доступных систем пуст')?></div>
      <?
    } 
    ?>
    <div class="nav2">
      <table class="table table-bordered" style="margin: 2px;">
        <tr>
          <td>
          <b><?= __('Логотип')?></b>
          </td>
          <td>
          <b><span class="on"><?= __('Информация')?></span></b>
          </td>
        </tr>
        <?
        foreach($list AS $post) {
          ?>
          <tr>
           <td style="width: 90px;"><img src="/plugins/payment/images/<?= $post['logo']?>" /></td>
            <td>
            :: <b><?= $post['name']?></b><br />
            <?= (isset($post['desc']) ? $post['desc'] : '')?>
            <br />
            <? if (!is_file(INI . 'payment.' . $post['identifier'] . '.dat')) { ?>
              <a href="?act=create&amp;identifier=<?= $post['identifier']?>" class="btn btn-primary"><?= __('Выбрать')?> &raquo;</a>
            <? } else { ?>
              <b class="btn btn-success">&radic; <?= __('Установлено')?></b>
            <? } ?>
            </td>
          </tr>
          <?
        }  
        ?>
      </table>
    </div>
    
    <div class="foot">
    &laquo; <a href="?"><?= __('Назад')?></a>
    </div>
    <?
  }

} else {

  ?>
  <div class="foot">
  <a href="?act=create"><i class="icon-plus"></i> <?= __('Добавить новую')?></a>
  </div>
  <?
  
  $list = $payment->getSystems('dat', 'all');
  $k_post = count($list);

  if ($k_post == 0) {
    ?>
    <div class="alert" style="margin: 2px;"><?= __('Список платежных систем пуст')?></div>
    <?
  } else {
    ?>
    <div class="nav2">
      <table class="table table-bordered" style="margin: 2px;">
        <tr>
          <td>
          <b><span class="on"><?= __('Логотип')?></span></b>
          </td>
          <td>
          <b><span class="on"><?= __('Информация')?></span></b>
          </td>
        </tr>
        <?
        foreach($list AS $post) {
          ?>
          <tr>
           <td style="width: 90px;"><img src="/plugins/payment/images/<?= $post['logo']?>" /></td>
            <td>
            :: <b><?= $post['name']?></b><br />
            <?= (isset($post['desc']) ? $post['desc'] : '')?>
            <br />
            
            <? if ($post['status'] == 0) { ?>
              <a href="?identifier=<?= $post['identifier']?>&amp;status=1" class="btn btn-success"><?= __('Включить')?></a>
            <? } else { ?>
              <a href="?identifier=<?= $post['identifier']?>&amp;status=0" class="btn btn-default"><?= __('Отключить')?></a>
            <? } ?>
            
            <a href="?act=edit&amp;identifier=<?= $post['identifier']?>" class="btn btn-info" title="<?= __('Параметры')?>"><i class="icon-wrench icon-white"></i> <?= __('Параметры')?></a>
            <a href="?act=delete&amp;identifier=<?= $post['identifier']?>" class="btn btn-danger" title="<?= __('Удалить')?>"><i class="icon-remove icon-white"></i> X</a>
            </td>
          </tr>
          <?
        }  
        ?>
      </table>
    </div>
    <?     
  }

}
?>
<div class="foot">
&laquo; <a href="index.php"><?= __('Админ панель')?></a>
</div>
<?
include_once H.'sys/inc/tfoot.php';