<?php 

class Payment extends Payment_Template
{
    // Платежная система
    public $paytype = '';
    
    // Тип услуги
    public $service = '';
    
    // Массив с настройками системы
    public $settings = array();
    
    // Массив с данными счета
    public $check = array();
    
    function __construct() {
        parent::__construct();
    }
    
    /**
    * Генерация формы платежа
    */
    public function getForm() {
        $settings = $this->getSettings($this->paytype);
        
        if (isset($settings['error'])) {
            return $settings;
        } 
        
        elseif ($settings['status'] == 1) {
            $this->assign('paytype', $this->paytype);
            $this->assign('pay_service_id', $this->check['service_id']);
            $this->assign('pay_service', $this->service);
            $this->assign('pay_id', $this->check['id']);
            $this->assign('pay_name', text($this->check['name']));
            $this->assign('pay_desc', text($this->check['name']));
            $this->assign('pay_user', $this->check['client_id']);
            $this->assign('pay_cost', number_format($this->check['wmr'] - $this->check['discount'], 2, '.', ''));
            $this->getParam($settings['PAYMENT']);
            $this->display($this->paytype);
        } else {
            return array('error' => __('Платеная система %s отключена', text($settings['name'])));
        }
    }
    
    /**
    * Генерация индивидуальных параметров формы
    * на основе настроек платежной системы
    */
    protected function getParam($array) {
        foreach ($array AS $key => $value) {
            $this->assign($key, $value);
        }
    }
    
    /**
    * Функция получения настроек платежной системы
    */
    public function getSettings($name) {
      
        $file = INI . 'payment.' . $name . '.';
        
        if (is_file($file . 'dat')) {
            $ras = 'dat';
        } elseif (is_file($file . 'ini')) {
            $ras = 'ini';
        } else {
            return array('error' => __('Платежная система %s не найдена', text($name)));
        }  

        $file = INI . 'payment.' . $name . '.' . $ras;
        
        $array = ($ras == 'ini' ? parse_ini_file($file, true) : unserialize(file_get_contents($file)));
        
        if (is_array($array)) {
            return $array;
        } else {
            return array('error' => __('Ошибка при чтении конфигурационного файла'));
        }
    }
    
    /**
    * Функция расчета скидки
    * 1. Цена 
    * 2. Скидка %
    */
    
    public function discount($price, $disc) {
      if ($disc > 0) {
          return round($price / 100 * $disc, 2);
      } else {
          return 0;
      }
    }
    
    /**
    *  Возвращает список платежных систем
    */
    
    public function getSystems($ras = 'ini', $act = 'active') {
      
        $array = array();
        
        $dir = opendir( INI );

        while ($file = readdir($dir)) {
          	if (preg_match('#^payment.([A-z0-9.]+).' . $ras . '$#i', $file)) {
                if ($act == 'active' && $ras == 'dat') {
                    $active = unserialize(file_get_contents(INI . $file));
                    if ($active['status'] == 1) {
                        $array[] = $active;
                    }
                } else {
                    $array[] = ($ras == 'ini' ? parse_ini_file(INI . $file, true) : unserialize(file_get_contents(INI . $file)));
                }
          	}
        }
        
        return $array;
    }
    
    
    /**
    *  Работа .dat файлами систем
    */
    
    public function getSave($name, $job = 'save', $resource) {
        $file = INI . 'payment.' . $name . '.dat';
        
        // Сохранение
        if ($job == 'save') {
            if (is_file($file)) {
                unlink($file);
            }
            
            if (file_put_contents($file, $resource)) {
                return true;
            } else {
                return false;
            }
        }
        
        // Удаление
        if ($job == 'unlink') {
            if (is_file($file)) {
                if (unlink($file)) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }
    
    public function cmp($a, $b) {
        return strcmp($a['PAYMENT']['COMISSION'], $b['PAYMENT']['COMISSION']);
    }
}