<?php

// "Базовый" класс для "кэширования".
// Этот класс реально ничего не кэширует, лишь реализует некоторые необходимые функции
// А так же описывает базовый интерфейс
class clCacheFake {
	// Пространство имён
	// Будет использоваться при построении ключей
	public $name_space = '';

	//======================================================================
	// Конструктор
	public function __construct() {
		// Вычисляем пространство имён на основе имени хоста
		$hostname = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '';
		$hostname = preg_replace('{^www\.}ui', '', $hostname);
		$this->name_space = crc32($hostname) . '_';
	}
	//======================================================================
	
	//======================================================================
	// Получение данных по ключу
	public function Get($key) {
		// Фейковый класс ничего не может вернуть
		return FALSE;
	}
	//======================================================================
	
	//======================================================================
	// Запись данных в кэш
	public function Set($key, $data, $ttl = 86400) {
		// Запись вкникуда всегда успешная:)
		return TRUE;
	}
	//======================================================================
	
	//======================================================================
	// Функция построения ключа в кэше
	public function PrepareCacheKey($data) {
		// Функция настоящая и будет использована во всех дочерних классах
		$rv = $this->name_space . md5(serialize($this->NormalizeArray($data)));
		return $rv;
	}
	//======================================================================
	
	//======================================================================
	// Нормализация массива
	private function NormalizeArray($a) {
		// Если массив
		if (is_array($a)) {
			// Сортируем ключи
			ksort($a);
			// Нормализуем значения
			foreach ($a as $key => $value) {
				$a[$key] = $this->NormalizeArray($value);
			}
		}
		return $a;
	}
	//======================================================================
}
