<?php
define("SMSC_LOGIN", "SimLove");		// логин клиента
define("SMSC_PASSWORD", "online");	// пароль или MD5-хеш пароля в нижнем регистре
define("SMSC_POST", 0);					// использовать метод POST
define("SMSC_HTTPS", 0);				// использовать HTTPS протокол
define("SMSC_CHARSET", "utf-8");	// кодировка сообщения: utf-8, koi8-r или windows-1251 (по умолчанию)
define("SMSC_DEBUG", 0);				// флаг отладки
define("SMTP_FROM", "api@smsc.ru");     // e-mail адрес отправителя
function send_sms($phones, $message, $translit = 0, $time = 0, $id = 0, $format = 0, $sender = false, $query = "")
{
	static $formats = array(1 => "flash=1", "push=1", "hlr=1", "bin=1", "bin=2", "ping=1");
	$m = _smsc_send_cmd("send", "cost=3&phones=".urlencode($phones)."&mes=".urlencode($message).
					"&translit=$translit&id=$id".($format > 0 ? "&".$formats[$format] : "").
					($sender === false ? "" : "&sender=".urlencode($sender))."&charset=".SMSC_CHARSET.
					($time ? "&time=".urlencode($time) : "").($query ? "&$query" : ""));
	if (SMSC_DEBUG) {
		if ($m[1] > 0)
			echo "Сообщение отправлено успешно. ID: $m[0], всего SMS: $m[1], стоимость: $m[2] руб., баланс: $m[3] руб.\n";
		else 
			echo "Ошибка №", -$m[1], $m[0] ? ", ID: ".$m[0] : "", "\n";
	}
	return $m;
}
function send_sms_mail($phones, $message, $translit = 0, $time = 0, $id = 0, $format = 0, $sender = "")
{
	return mail("send@send.smsc.ru", "", SMSC_LOGIN.":".SMSC_PASSWORD.":$id:$time:$translit,$format,$sender:$phones:$message", "From: ".SMTP_FROM."\nContent-Type: text/plain; charset=".SMSC_CHARSET."\n");
}
function get_sms_cost($phones, $message, $translit = 0, $format = 0, $sender = false, $query = "")
{
	static $formats = array(1 => "flash=1", "push=1", "hlr=1", "bin=1", "bin=2", "ping=1");
	$m = _smsc_send_cmd("send", "cost=1&phones=".urlencode($phones)."&mes=".urlencode($message).
					($sender === false ? "" : "&sender=".urlencode($sender))."&charset=".SMSC_CHARSET.
					"&translit=$translit".($format > 0 ? "&".$formats[$format] : "").($query ? "&$query" : ""));
	if (SMSC_DEBUG) {
		if ($m[1] > 0)
			echo "Стоимость рассылки: $m[0] руб. Всего SMS: $m[1]\n";
		else
			echo "Ошибка №", -$m[1], "\n";
	}
	return $m;
}
function get_status($id, $phone, $all = 0)
{
	$m = _smsc_send_cmd("status", "phone=".urlencode($phone)."&id=".$id."&all=".(int)$all);
	if (SMSC_DEBUG) {
		if ($m[1] != "" && $m[1] >= 0)
			echo "Статус SMS = $m[0]", $m[1] ? ", время изменения статуса - ".date("d.m.Y H:i:s", $m[1]) : "", "\n";
		else
			echo "Ошибка №", -$m[1], "\n";
	}
	if ($all && count($m) > 9 && (!isset($m[14]) || $m[14] != "HLR")) // ',' в сообщении
		$m = explode(",", implode(",", $m), 9);
	return $m;
}
function get_balance()
{
	$m = _smsc_send_cmd("balance"); // (balance) или (0, -error)
	if (SMSC_DEBUG) {
		if (!isset($m[1]))
			echo "Сумма на счете: ", $m[0], " руб.\n";
		else
			echo "Ошибка №", -$m[1], "\n";
	}
	return isset($m[1]) ? false : $m[0];
}
function _smsc_send_cmd($cmd, $arg = "")
{
	$url = (SMSC_HTTPS ? "https" : "http")."://smsc.ru/sys/$cmd.php?login=".urlencode(SMSC_LOGIN)."&psw=".urlencode(SMSC_PASSWORD)."&fmt=1&".$arg;
	$i = 0;
	do {
		if ($i)
			sleep(2);
		$ret = _smsc_read_url($url);
	}
	while ($ret == "" && ++$i < 3);
	if ($ret == "") {
		if (SMSC_DEBUG)
			echo "Ошибка чтения адреса: $url\n";
		$ret = ","; // фиктивный ответ
	}
	return explode(",", $ret);
}
function _smsc_read_url($url)
{
	$ret = "";
	$post = SMSC_POST || strlen($url) > 2000;
	if (function_exists("curl_init"))
	{
		static $c = 0; // keepalive
		if (!$c) {
			$c = curl_init();
			curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($c, CURLOPT_CONNECTTIMEOUT, 10);
			curl_setopt($c, CURLOPT_TIMEOUT, 10);
			curl_setopt($c, CURLOPT_SSL_VERIFYPEER, 0);
		}
		if ($post) {
			list($url, $post) = explode('?', $url, 2);
			curl_setopt($c, CURLOPT_POST, true);
			curl_setopt($c, CURLOPT_POSTFIELDS, $post);
		}
		curl_setopt($c, CURLOPT_URL, $url);
		$ret = curl_exec($c);
	}
	elseif (!SMSC_HTTPS && function_exists("fsockopen"))
	{
		$m = parse_url($url);
		$fp = fsockopen($m["host"], 80, $errno, $errstr, 10);
		if ($fp) {
			fwrite($fp, ($post ? "POST $m[path]" : "GET $m[path]?$m[query]")." HTTP/1.1\r\nHost: smsc.ru\r\nUser-Agent: PHP".($post ? "\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: ".strlen($m['query']) : "")."\r\nConnection: Close\r\n\r\n".($post ? $m['query'] : ""));
			while (!feof($fp))
				$ret .= fgets($fp, 1024);
			list(, $ret) = explode("\r\n\r\n", $ret, 2);
			fclose($fp);
		}
	}
	else
		$ret = file_get_contents($url);
	return $ret;
}
?>