/**
 * Created by DES on 07.11.2015.
 */
(function () {
    angular.module('app.Form', [])
        /**
         * Отправка формы ajax запросом без перезагрузки страницы
         */
        .directive('ajaxForm', function () {
            return {
                restrict: 'A',
                link: function (scope, element, attrs) {
                    scope.action = element[0].action;
                    scope.method = element[0].method;
                    scope.id = element[0].id;

                    element.on('submit', function (event) {
                        var data = {};
                        angular.forEach(element[0], function (input) {
                            if (input.name) {
                                data[input.name] = input.value;
                            }
                        });
                        event.preventDefault();
                        scope.send(data);
                    });

                    /**
                     * обновление формы после отправки
                     * @param formConfig
                     */
                    scope.updateForm = function (formConfig) {
                        angular.forEach(formConfig.Items, function (item) {
                            if (!item.Name) {
                                return;
                            }

                            if (element[0][item.Name]) {
                                angular.element(element[0][item.Name]).val(item.Value);
                            }
                        });
                    };
                },
                controller: function ($scope, $http, $rootScope) {
                    $scope.id = "";
                    $scope.action = "";
                    $scope.method = "post";
                    $scope.process = false;
                    $scope.send = function (request) {
                        $scope.process = true;

                        $http({ url: $scope.action, method: $scope.method, data: request })
                            .success(function (response) {

                                if (response.Form) {
                                    // обновляем отправленную форму
                                    $scope.updateForm(response.Form);
                                }

                                // сообщаем, что форма отправлена. обычно на это событие подписывается привязанный листинг для обновления
                                $rootScope.$broadcast('formSubmitted', $scope.id, response);
                            })
                            .finally(function () {
                                $scope.process = false;
                            });
                    }
                }
            }
        });
})();