<?php
/** @var \Dcms\Ui\Post $model */
use Dcms\Helpers\Text;

?>
<div id="<?= $model->getId() ?>" class="<?= join(' ', $model->_getAllClasses()) ?> clearfix common-block"
     data-url="<?= Text::toValue($model->getUrl()) ?>">
    <div class="header">
        <span class="image"><img src="<?= Text::toValue($model->getImageSrc()) ?>"/></span>
        <span class="icon"><img src="<?= Text::toValue($model->getIconSrc()) ?>"/></span>
        <a class="title" href="<?= Text::toValue($model->getUrl()) ?>"><?= Text::toValue($model->getTitle()) ?></a>
        <span class="counter"><?= Text::toValue($model->getCounter()) ?></span>
        <span class="time"><?= Text::toValue($model->getTime()) ?></span>
        <span class="actions">
        <?php
        foreach ($model->getActions() AS $action) {
            echo '<a href="' . Text::toValue($action->getUrl()) . '">' . Text::toValue($action->getText()) . '</a>' . PHP_EOL;
        }
        ?>
        </span>
    </div>
    <div class="content">
        <?php
        foreach ($model->getItems() AS $item) {
            echo $item->render();
        }
        ?>
    </div>
    <div class="bottom"><?= $model->getBottomHtml() ?></div>
</div>