<?php
/**
 * @var \Dcms\Ui\Page $model
 */
use Dcms\Helpers\Text;
use Dcms\System\Core;
?><!DOCTYPE html>
<html>
<head>
    <title><?= Text::toValue($model->getTitle()) ?></title>
    <link rel="shortcut icon" href="/favicon.ico?v=2" type="image/x-icon">
    <?php
    foreach ($model->getStylesheets() AS $href) {
        $href = Text::toValue($href);
        echo "    <link rel='stylesheet' type='text/css' href='{$href}'>" . PHP_EOL;
    }
    foreach ($model->getScripts() AS $src) {
        $src = Text::toValue($src);
        echo "    <script type='text/javascript' src='{$src}'></script>" . PHP_EOL;
    } ?>
</head>
<body class="<?= $model->getFullSize() ? 'is_full_size' : '' ?>" data-ng-app="app">
<div id="main">
    <div id="top_part">
        <div id="header">
            <div class="body_width_limit">
                <div id="main_menu">
                    <?php echo $model->renderMenu('main_menu'); ?>
                </div>
                <?php echo $model->renderSection('header'); ?>
                <div id="breadcrumbs">
                    <?php
                    foreach ($model->getBreadcrumbs() AS $bc) {
                        $url = Text::toValue($bc->getUrl());
                        $text = Text::toValue($bc->getText());
                        echo "<a href='{$url}'>{$text}</a>";
                    }
                    ?>
                </div>
            </div>
            <div id="actions">
                <div class="body_width_limit">
                    <?php
                    foreach ($model->getActions() AS $act) {
                        $url = Text::toValue($act->getUrl());
                        $text = Text::toValue($act->getText());
                        echo "<a href='{$url}'>{$text}</a>";
                    }
                    ?>
                </div>
            </div>
        </div>
        <div id="middle" class="body_width_limit clearfix">
            <div id="messages">
                <?php
                foreach ($model->getMessages() AS $message) {
                    $message = Text::toValue($message);
                    echo "<div>{$message}</div>";
                }
                ?>
            </div>
            <div id="content" class="all_space_on_full_size">
                <?php
                foreach ($model->getItems() AS $item) {
                    echo $item->render();
                }
                ?>
            </div>
            <div id="right_column" class="hide_on_full_size">
                <?php echo $model->renderSection('right_column'); ?>
            </div>
        </div>
    </div>
    <div id="footer">
        <div class="body_width_limit clearfix">
            <span>@DCMS</span>
            <?php echo $model->renderSection('footer'); ?>
            <span style="float:right">page gen: <?= Core::getElapsedTime() ?></span>
        </div>
    </div>
</div>
</body>
</html>
