<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 15.10.2015
 * Time: 19:24
 */

namespace Modules\Comments;


use Dcms\Helpers\FileSystem;
use Dcms\Helpers\Text;
use Dcms\Helpers\Url;
use Dcms\System\Core;
use Dcms\System\Request;
use Dcms\System\Responses\Redirect;
use Dcms\System\Responses\ResponseJson;
use Dcms\Ui\Form;
use Dcms\Ui\Input;
use Dcms\Ui\Listing;
use Dcms\Ui\Post;
use Dcms\Ui\RichText;
use Dcms\Ui\Ui;

class Module extends \Dcms\System\Packages\Models\Module
{

    public function get(Request $request)
    {
        $subject = $request->getPathVariable('subject');

        $form = $this->_getForm($subject);
        $listing = $this->getListing($request);
        $listing->setAjaxFormId($form->getId());
        $listing->setAjaxUrl("/api/comments/" . $subject . '/listing');

        return new Ui([
            "Items" => [
                $form,
                $listing
            ]
        ]);
    }

    /**
     * Обработка сохранения сообщения
     * @param Request $request
     * @return Redirect|ResponseJson|null
     * @throws \Exception
     */
    public function post(Request $request)
    {
        $subject = $request->getPathVariable('subject');
        $data = $request->getData();
        $params = [
            'subject' => $request->getPathVariable('subject'),
            'text' => Text::toSave($data['text']),
            'id_user' => 1
        ];

        $prep = Core::getDb()->prepare("INSERT INTO `comments` (`id_user`, `subject`, `text`) VALUES(:id_user, :subject, :text)");
        $prep->execute($params);

        if ($request->getAcceptType() === 'html' && $data['return']) {
            return new Redirect($data['return']); // возвращаем на страницу, откуда пришли данные формы
        }

        if ($request->getAcceptType() === 'json') {
            return new ResponseJson(
                [
                    "Content" => [
                        "Form" => $this->_getForm($subject)->getConfig()
                    ]
                ]
            );
        }

        return null;
    }

    public function getListing(Request $request)
    {
        $subject = $request->getPathVariable('subject');
        $prep = Core::getDb()->prepare("SELECT * FROM `comments` WHERE `subject` = :subject ORDER BY id DESC");
        $prep->execute(["subject" => $subject]);
        $all_comments = $prep->fetchAll();
        return $this->_getListing($all_comments);
    }

    private function _getListing($all_comments, $id_parent = null)
    {
        $listing = new Listing();
        for ($i = 0; $i < count($all_comments); $i++) {
            $comment = $all_comments[$i];

            if ($comment['id_parent'] !== $id_parent) {
                continue;
            }

            $listing->addItem($post = new Post());
            $data = [
                "Comment" => $comment,
                "Post" => $post
            ];

            $this->_commentToPost($data);
            Core::hook('comments:post', $data);

            // вложенные комменты
            $child_listing = $this->_getListing($all_comments, $comment['id']);
            if ($child_listing->getItems()) {
                $listing->addItem($child_listing);
            }

        }
        return $listing;
    }

    /**
     * Заполнение элемента списка комментариев по записи
     * @param $data
     */
    private function _commentToPost(&$data)
    {
        /**
         * @var Post $post
         */
        $post = &$data['Post'];
        /**
         * строка из таблицы comments
         */
        $comment = &$data['Comment'];

        $post->setTitle("Юзер " . $comment['id_user']);
        $post->addContentHtml(Text::toOutput($comment['text']));
    }

    private function _getForm($subject)
    {
        $form = new Form([
            'Url' => FileSystem::getRelPath('/api/comments/' . $subject),
            "AjaxSupport" => true,
            'Items' => [
                new RichText([
                    'Title' => __('Новое сообщение'),
                    'Name' => 'text',
                ]),
                new Input([
                    'Type' => 'submit',
                    'Value' => __('Отправить')
                ]),
                new Input([
                    'Type' => 'hidden',
                    'Name' => 'return',
                    'Value' => new Url(null)
                ])
            ]
        ]);
        return $form;
    }
}