<?php
use Dcms\Helpers\Json;
use Dcms\System\Core;

version_compare(PHP_VERSION, '5.4', '>=') or die('Требуется PHP >= 5.4');

define('H', realpath(__DIR__ . '/../'));
define('DCMS_REWRITE_URL', 'REWRITE_URL');

/**
 * Автоматическая загрузка классов в соответствии с PSR-0
 */
require_once('classes/SplClassLoader.php');
$loader = new SplClassLoader(null, H . '/sys/classes');
$loader->register();
unset($loader);

/**
 * Автоматическая загрузка пакетов (модулей, тем оформления, плагинов и виджетов)
 */
require_once('classes/SplClassLoader.php');
$loader = new SplClassLoader(null, H . '/sys/packages');
$loader->register();
unset($loader);


/**
 * Локализация и формат текстовой строки.
 * работает как sprintf http://php.net/manual/ru/function.sprintf.php
 * @return string Локализованная строка
 * @throws \Exception
 */
function __()
{
    $args = func_get_args();
    $args_num = count($args);
    if (!$args_num) {
        throw new \Exception("no params");
    }

    if ($args_num == 1) {
        // строка без параметров
        return $args[0];
    }

    Core::hook('localization', $args);
    return call_user_func_array('sprintf', $args);
}

/**
 * Инициализация ядра системы
 */
if (file_exists(__DIR__ . '/config.json')) {
    Core::init(Json::parse(file_get_contents(__DIR__ . '/config.json')));
} else {
    Core::init([
        "installing" => true
    ]);
}

