<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 15:01
 */

namespace Dcms\Ui;

use Dcms\Helpers\Configurator;
use Dcms\Helpers\TemplateRender;
use Dcms\System\Core;

class Ui extends Configurator
{
    protected
        $_id,
        $_items = [];

    function __construct($config = [])
    {
        parent::__construct($config);
        $this->_id = $this->_getNewId();
    }

    /**
     * Возвращает уникальный идентификатор класса на странице
     * @staticvar array $id
     * @return string
     */
    protected function _getNewId()
    {
        static $id = array();
        $class = $this->_getShortNameClass(get_class($this));
        return $class . '_' . @++$id[$class];
    }

    /**
     * Возвращает имя класса без неймспейса
     * @param string $name_with_namespace
     * @return string
     */
    protected function _getShortNameClass($name_with_namespace)
    {
        return (new \ReflectionClass($name_with_namespace))->getShortName();
    }


    /**
     * Отрисовка модели при помощи шаблона темы оформления.
     * Поиск шаблона производится по имени текущего класса модели, затем перебираются все родители.
     * @throws \Exception
     * @return string
     */
    protected function _render()
    {
        $design = new TemplateRender();
        $design->assign('model', $this);

        $current_class = $class = get_class($this);

        do {
            $short_class_name = $this->_getShortNameClass($class);

            if ($template_path = Core::getThemes()->getThemeTemplatePath(Core::getThemes()->getCurrentTheme(), $short_class_name)) {
                return $design->render($template_path);
            }
        } while ($class !== 'ui' && $class = get_parent_class($class));

        throw new \Exception(__('Нет шаблона для отображения модели %s', $this->_getShortNameClass($current_class)));
    }

    /**
     * Отрисовка модели при помощи шаблона темы оформления.
     * Можно переопределить хуком ui:render
     * @throws \Exception
     * @return string
     */
    public function render()
    {
        $data = [
            "model" => $this,
            "result" => null
        ];
        //Core::hook('ui:render', $data);

        if ($data['result']) {
            return $data['result'];
        }

        return $this->_render();
    }

    public function display()
    {
        echo $this->render();
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->_id;
    }

    /**
     * @param string $id
     */
    public function setId($id)
    {
        $this->_id = $id;
    }


    /**
     * @param ui[]|array[] $items []
     */
    public function setItems($items)
    {
        $this->_items = [];
        foreach ($items AS $item) {
            $this->addItem($item);
        }
    }

    /**
     * @return ui[]
     */
    public function getItems()
    {
        return $this->_items;
    }

    /**
     * @param ui|array $ui
     * @throws \Exception
     */
    public function addItem($ui)
    {
        if (!($ui instanceof ui)) {
            $class_name = $ui['Class'] ? $ui['Class'] : 'ui';

            if (!($class_name instanceof ui)) {
                throw new \Exception(__("Класс %s не является наследником ui", $class_name));
            }
            $ui = new $class_name($ui);
        }

        $this->_items[] = $ui;
    }

    /**
     * Возвращает все классы до ui включительно
     * @return string[]
     */
    final public function _getAllClasses()
    {
        $class = get_class($this);
        $short_class_name = $this->_getShortNameClass($class);;
        $classes = [$short_class_name];
        while ($short_class_name !== 'Ui' && $class = get_parent_class($class)) {
            $classes[] = $short_class_name = $this->_getShortNameClass($class);
        }

        return  array_reverse($classes);
    }
}