<?php

namespace Dcms\Ui;

class Select extends Ui
{
    protected $_title = '';
    protected $_name = '';


    /**
     * @return Option[]
     */
    public function getItems()
    {
        return $this->_items;
    }

    /**
     * @param array[]|Option[] $options
     */
    public function setItems($options)
    {
        $this->_items = [];
        foreach($options AS $option){
            $this->addItem($option);
        }
    }

    /**
     * @param $option Option|array
     */
    public function addItem($option){
        if (!($option instanceof Option)){
            $option = new Option($option);
        }
        $this->_items[] = $option;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->_title;
    }

    /**
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->_title = $title;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->_name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->_name = $name;
    }
}