<?php

namespace Dcms\Ui;

use Dcms\System\Core;
use Dcms\System\Taxonomy;
use Dcms\Ui\Data\Link;

/**
 * Модель страницы
 */
class Page extends Ui
{
    protected
        $_title = "",
        $_stylesheets = [],
        $_scripts = [],
        $_keywords = [],
        $_breadcrumbs = [],
        $_actions = [],
        $_messages = [],
        $_description = '',
        $_full_size = false;

    function __construct($config = [])
    {
        $this->_defaultResources();
        parent::__construct($config);
    }

    protected function _defaultResources()
    {
        $themes = Core::getThemes();
        $current_theme = $themes->getCurrentTheme();

        $this->setStylesheets($themes->getThemeResources($current_theme, 'css'));
        $this->setScripts($themes->getThemeResources($current_theme, 'js'));
    }

    /**
     * @return string[]
     */
    public function getStylesheets()
    {
        return $this->_stylesheets;
    }

    /**
     * @param string[] $stylesheets
     */
    public function setStylesheets($stylesheets)
    {
        $this->_stylesheets = $stylesheets;
    }

    /**
     * @return string[]
     */
    public function getScripts()
    {
        return $this->_scripts;
    }

    /**
     * @param string[] $scripts
     */
    public function setScripts($scripts)
    {
        $this->_scripts = $scripts;
    }

    /**
     * @return string[]
     */
    public function getKeywords()
    {
        return $this->_keywords;
    }

    /**
     * @param string[] $keywords
     */
    public function setKeywords($keywords)
    {
        $this->_keywords = $keywords;
    }

    /**
     * @return Link[]
     */
    public function getBreadcrumbs()
    {
        return $this->_breadcrumbs;
    }

    /**
     * @param Link[] $breadcrumbs
     */
    public function setBreadcrumbs($breadcrumbs)
    {
        $this->_breadcrumbs = $breadcrumbs;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->_description;
    }

    /**
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->_description = $description;
    }

    /**
     * @return boolean
     */
    public function getFullSize()
    {
        return $this->_full_size;
    }

    /**
     * @param boolean $full_size
     */
    public function setFullSize($full_size)
    {
        $this->_full_size = $full_size;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->_title;
    }

    /**
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->_title = $title;
    }

    /**
     * @return string[]
     */
    public function getMessages()
    {
        return $this->_messages;
    }

    /**
     * @param string[] $messages
     */
    public function setMessages($messages)
    {
        $this->_messages = $messages;
    }

    /**
     * @return Link[]
     */
    public function getActions()
    {
        return $this->_actions;
    }

    /**
     * @param Link[] $actions
     */
    public function setActions($actions)
    {
        $this->_actions = $actions;
    }

    /**
     * @param $string
     * @return string
     */
    public function renderSection($string)
    {
        // todo
    }

    /**
     * @param $menu_name
     * @return string
     * @throws \Exception
     * @internal param $string
     */
    public function renderMenu($menu_name)
    {
        $taxonomy = new Taxonomy(2);
        $themes = Core::getThemes();
        $current_theme = $themes->getCurrentTheme();
        return $themes->renderThemeMenu($current_theme, $taxonomy);
    }
} 