<?php

namespace Dcms\Ui;

use Dcms\Helpers\Url;

/**
 * Class Form
 */
class Form extends Ui
{
    protected
        $_method = 'post',
        $_url = null,
        $_ajax_support = false;


    /**
     * @return string
     */
    public function getMethod()
    {
        return strtolower($this->_method);
    }

    /**
     * @param string $method
     */
    public function setMethod($method)
    {
        $this->_method = $method;
    }

    /**
     * @return Url
     */
    public function getUrl()
    {
        return $this->_url;
    }

    /**
     * @param Url|string $url
     */
    public function setUrl($url)
    {
        $this->_url = new Url($url);
    }

    /**
     * @return boolean
     */
    public function getAjaxSupport()
    {
        return $this->_ajax_support;
    }

    /**
     * @param boolean $ajax_support
     */
    public function setAjaxSupport($ajax_support)
    {
        $this->_ajax_support = $ajax_support;
    }

}