<?php

namespace Dcms\Ui;

class Checkbox extends Input
{
    protected
        $_type = 'checkbox',
        $_name = '',
        $_value = '1',
        $_checked = false;

    public function getContentHtml()
    {
        $attributes = array(
            'type' => $this->getType(),
            'name' => $this->getName(),
            'value' => $this->getValue()
        );

        if ($this->isChecked()){
            $attributes['checked'] = 'checked';
        }

        if (!$this->isEnabled()) {
            $attributes['disabled'] = 'disabled';
        }

        $attributes_seq = array();
        foreach ($attributes AS $key => $value) {
            $attributes_seq[] = $key . '="' . text::toValue($value) . '"';
        }

        $code = '<span id="' . $this->getId() . '" class="ui_form_input ui_form_checkbox"><label><input ' . join(' ', $attributes_seq) . ' />' . $this->getTitle() . '</label></span>';


        if ($this->getIsBlock()) {
            $code .= '<br />';
        }

        return $code;
    }

    /**
     * @return boolean
     */
    public function isChecked()
    {
        return $this->_checked;
    }

    /**
     * @param boolean $checked
     */
    public function setChecked($checked)
    {
        $this->_checked = $checked;
    }

}