<?php
/**
 * Created by PhpStorm.
 * User: DES
 * Date: 04.11.2015
 * Time: 16:29
 */

namespace Dcms\System;


use Dcms\Helpers\Url;

class Taxonomy
{
    static protected $_taxonomy = null;

    protected $_id = null;
    protected $_id_parent = null;
    protected $_name = "";
    protected $_sort = 0;
    protected $_url = null;

    static protected function _getAllTaxonomy()
    {
        if (is_null(self::$_taxonomy)) {
            self::$_taxonomy = Core::getDb()->query("SELECT * FROM `taxonomy`")->fetchAll();
        }
        return self::$_taxonomy;
    }

    public function __construct($id = null)
    {
        if (!is_null($id)) {
            $all = self::_getAllTaxonomy();
            foreach ($all AS $item) {
                if ($item['id'] != $id) {
                    continue;
                }

                $this->_id = $item['id'];
                $this->_id_parent = $item['id_parent'];
                $this->_sort = $item['sort'];
                $this->_url = $item['url'];
                $this->_name = $item['name'];

                break;
            }

            if (is_null($this->_id)) {
                throw new \Exception(__('Таксономия "%s" не найдена', $id));
            }
        }
    }

    /**
     * @return Taxonomy[]
     */
    public function getItems()
    {
        $items = [];
        $all = self::_getAllTaxonomy();
        foreach ($all AS $item) {
            if ($item['id_parent'] !== $this->_id)
                continue;
            $items[] = new Taxonomy($item['id']);
        }

        return $items;
    }

    /**
     * Возвращает коэффициент совпадения Url пункта таксономии с указанным (или текущим) Url
     * @param $item
     * @param null|Url $url Путь, с которым будет производиться сравнение. (если не указывать, то будет сравнение с текущим)
     * @return float|int Коэффициент совпадения от 0 до 1. 1 - полное совпадение.
     * @throws \Exception
     */
    static public function getCompareRate(Taxonomy $item, $url = null)
    {
        if ($url instanceof Url) {
            $current_url = $url;
        } else {
            $current_url = new Url($url);
        }

        if (!$item->getUrl()) {
            return 0;
        }

        $item_url = new Url($item->getUrl());

        if (!$current_url->isInternalLink() || !$item_url->isInternalLink()) {
            // внешние ссылки не сравниваем
            return 0;
        }

        $current_path = $current_url->getPath();
        $item_path = $item_url->getPath();

        $current_params = $current_url->getParams();
        $item_params = $item_url->getParams();

        if ($current_path === $item_path) {
            $current_diff_params = array_diff_assoc($current_params, $item_params);
            $item_diff_params = array_diff_assoc($item_params, $current_params);

            if (!$current_diff_params && !$item_diff_params) {
                // разница в GET параметрах отсутствует
                return 1;
            } elseif ($current_diff_params && !$item_diff_params) {
                // в текущем Url присутствуют дополнительные GET параметры, дополняющие GET параметры в пункте меню
                return (count($item_params) + 1) / (count($current_params) + 1);
            } elseif (!$current_diff_params && $item_diff_params) {
                // в текущем Url отсутствуют параметры, которые есть в пункте меню
                //return (count($current_params) + 1) / (count($item_params) + 1) / 2;
            }
        }

        if (strrpos($current_path, $item_path, -strlen($current_path)) !== FALSE) {
            // текущий Url глубже пути в пункте меню.
            return strlen($item_path) / strlen($current_path) / 2;
        }

        return 0;
    }

    static public function flushCache()
    {
        self::$_taxonomy = null;
    }

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->_id;
    }

    /**
     * @return int|null
     */
    public function getIdParent()
    {
        return $this->_id_parent;
    }

    /**
     * @param int|null $id_parent
     */
    public function setIdParent($id_parent)
    {
        $this->_id_parent = $id_parent;
    }

    /**
     * @return int
     */
    public function getSort()
    {
        return $this->_sort;
    }

    /**
     * @param int $sort
     */
    public function setSort($sort)
    {
        $this->_sort = $sort;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->_name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->_name = $name;
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->_url;
    }

    /**
     * @param string $url
     */
    public function setUrl($url)
    {
        $this->_url = $url;
    }
}