<?php
/**
 * Created by PhpStorm.
 * User: DES
 * Date: 17.11.2015
 * Time: 1:27
 */

namespace Dcms\System;


use Dcms\Helpers\Text;

/**
 * Прослойка для хранения настроек с определенным префиксом
 * Class SettingsProxy
 * @package Dcms\System
 */
class SettingsProxy implements \ArrayAccess, \Iterator
{
    protected $_index = 0;
    protected $_prefix, $_settings;

    /**
     * @param Settings $settings
     * @param string $prefix префикс, под которым данные настройки будут храниться среди общих
     * @throws \Exception
     */
    public function __construct(Settings $settings, $prefix)
    {
        $this->_prefix = Text::toSave($prefix);
        $this->_settings = $settings;
    }

    protected function _getKey($key)
    {
        return $this->_prefix . '~' . $key;
    }

    public function offsetExists($offset)
    {
        return $this->_settings->offsetExists($this->_getKey($offset));
    }

    public function offsetGet($offset)
    {
        return $this->_settings->offsetGet($this->_getKey($offset));
    }

    public function offsetSet($offset, $value)
    {
        $this->_settings->offsetSet($this->_getKey($offset), $value);
    }

    public function offsetUnset($offset)
    {
        $this->_settings->offsetUnset($this->_getKey($offset));
    }

    /**
     * массив ключей без префиксов
     * @return string[]
     */
    public function getKeys()
    {
        $prefix = $this->_prefix . '~';
        $prefix_len = strlen($prefix);
        $k = $this->_settings->getKeys();
        $inner_keys = [];
        foreach ($k AS $key) {
            $pos = stripos($key, $prefix);
            if ($pos === 0) {
                $inner_keys[] = substr_replace($key, '', $pos, $prefix_len);
            }
        }
        return $inner_keys;
    }

    /**
     * очистка всех настроек
     * @param bool $apply_now немедленная запись в базу данных
     */
    public function clear($apply_now = false)
    {
        foreach ($this->getKeys() AS $key) {
            unset($this[$key]);
        }
        if ($apply_now) {
            $this->_settings->saveNow();
        }
    }

    public function rewind()
    {
        $this->_index = 0;
    }

    public function current()
    {
        $k = $this->getKeys();
        $var = $this->_settings[$k[$this->_index]];
        return $var;
    }

    public function key()
    {
        $k = $this->getKeys();
        $var = $k[$this->_index];
        return $var;
    }

    public function next()
    {
        $k = $this->getKeys();
        if (isset($k[++$this->_index])) {
            $var = $this->_settings[$k[$this->_index]];
            return $var;
        } else {
            return false;
        }
    }

    public function valid()
    {
        $k = $this->getKeys();
        $var = isset($k[$this->_index]);
        return $var;
    }
}