<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 15:32
 */

namespace Dcms\System;
use Dcms\Helpers\Json;

/**
 * Системные настройки. Доступ как к ассоциативному массиву
 * Class Settings
 * @package Dcms\System
 */
class Settings implements \ArrayAccess, \Iterator
{
    private $_index = 0;

    private $_settings = [];
    private $_to_update = [];
    private $_to_delete = [];
    private $_db;

    public function __construct(Db $db)
    {
        $this->_db = $db;
        $q = $db->query("SELECT * FROM `settings`");
        foreach ($q->fetchAll() AS $row) {
            $this->_settings[$row['key']] = $row['value'];
        }
    }

    public function getKeys()
    {
        return array_keys($this->_settings);
    }

    /**
     * (PHP 5 &gt;= 5.0.0)<br/>
     * Whether a offset exists
     * @link http://php.net/manual/en/arrayaccess.offsetexists.php
     * @param mixed $offset <p>
     * An offset to check for.
     * </p>
     * @return boolean true on success or false on failure.
     * </p>
     * <p>
     * The return value will be casted to boolean if non-boolean was returned.
     */
    public function offsetExists($offset)
    {
        return array_key_exists($offset, $this->_settings);
    }

    /**
     * (PHP 5 &gt;= 5.0.0)<br/>
     * Offset to retrieve
     * @link http://php.net/manual/en/arrayaccess.offsetget.php
     * @param mixed $offset <p>
     * The offset to retrieve.
     * </p>
     * @return mixed Can return all value types.
     */
    public function offsetGet($offset)
    {
        return Json::parse($this->_settings[$offset]);
    }

    /**
     * (PHP 5 &gt;= 5.0.0)<br/>
     * Offset to set
     * @link http://php.net/manual/en/arrayaccess.offsetset.php
     * @param mixed $offset <p>
     * The offset to assign the value to.
     * </p>
     * @param mixed $value <p>
     * The value to set.
     * </p>
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->_settings[$offset] = Json::stringify($value, false);
        unset($this->_to_delete[$offset]);
        $this->_to_update[$offset] = true;
    }

    /**
     * (PHP 5 &gt;= 5.0.0)<br/>
     * Offset to unset
     * @link http://php.net/manual/en/arrayaccess.offsetunset.php
     * @param mixed $offset <p>
     * The offset to unset.
     * </p>
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->_settings[$offset]);
        unset($this->_to_update[$offset]);
        $this->_to_delete[$offset] = true;
    }

    public function rewind()
    {
        $this->_index = 0;
    }

    public function current()
    {
        $k = $this->getKeys();
        $var = $this->_settings[$k[$this->_index]];
        return $var;
    }

    public function key()
    {
        $k = $this->getKeys();
        $var = $k[$this->_index];
        return $var;
    }

    public function next()
    {
        $k = $this->getKeys();
        if (isset($k[++$this->_index])) {
            $var = $this->_settings[$k[$this->_index]];
            return $var;
        } else {
            return false;
        }
    }

    public function valid()
    {
        $k = $this->getKeys();
        $var = isset($k[$this->_index]);
        return $var;
    }

    /**
     * Немедленное сохранение всех настроек в базе
     */
    public function saveNow()
    {
        if (!$this->_to_update && !$this->_to_delete)
            return;

        $keys_update = array_keys($this->_to_update);
        $keys_delete = array_keys($this->_to_delete);

        $db = $this->_db;

        if ($keys_delete) {
            $qMarks = str_repeat('?,', count($keys_delete) - 1) . '?';
            $sth = $db->prepare("DELETE FROM `settings` WHERE `key` IN ($qMarks)");
            $sth->execute($keys_delete);
        }

        if ($keys_update) {
            $qMarks = str_repeat('(?,?),', count($keys_update) - 1) . '(?,?)';
            $execute_props = [];
            foreach ($keys_update AS $key) {
                $execute_props[] = $key;
                $execute_props[] = $this->_settings[$key];
            }
            $sth = $db->prepare("INSERT INTO `settings` (`key`, `value`) VALUES $qMarks ON DUPLICATE KEY UPDATE `value` = VALUES(`value`)");
            $sth->execute($execute_props);
        }
    }

    /**
     * Отложенное обновление изменений настроек в базе данных
     */
    public function __destruct()
    {
        $this->saveNow();
    }
}