<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 15:16
 */

namespace Dcms\System\Responses;


use Dcms\Helpers\Configurator;
use Dcms\Helpers\FileSystem;
use Dcms\Helpers\Json;
use Dcms\Ui\Html;
use Dcms\Ui\Page;
use Dcms\Ui\Ui;

/**
 * Ответ клиенту (браузеру)
 * Class Response
 * @package Dcms\System\Responses
 */
class Response extends Configurator
{
    protected
        $_content = '',
        $_headers = [],
        $_status = 200;

    public function send($asJson = false)
    {
        http_response_code($this->_status);
        foreach ($this->_headers AS $header) {
            header($header, true);
        }

        $content = $this->_content;

        if ($asJson) {
            header('Content-Type: application/json; charset=utf-8', true);

            if ($content instanceof Configurator) {
                $content = Json::stringify($content->getConfig());
            }
            if ($content instanceof \Exception) {
                $content = Json::stringify([
                    'Message' => $content->getMessage()
                ]);
            }

        } else if ($content instanceof Ui) {
            $content = $content->render();
        }

        exit($content);
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->_content;
    }

    /**
     * @param string|Ui $content
     */
    public function setContent($content)
    {
        $this->_content = $content;
    }

    /**
     * @return string[]
     */
    public function getHeaders()
    {
        return $this->_headers;
    }

    /**
     * @param string[] $headers
     */
    public function setHeaders($headers)
    {
        $this->_headers = $headers;
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->_status;
    }

    /**
     * @param int $status
     */
    public function setStatus($status)
    {
        $this->_status = $status;
    }
}