<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 25.09.2015
 * Time: 15:46
 */

namespace Dcms\System\Responses;


use Dcms\Helpers\Url;

/**
 * Переадресация клиента на другой Url
 * По умолчанию отправляется с 302 статусом (временно перемещено)
 * Class Redirect
 * @package Dcms\System\Responses
 */
class Redirect extends Response
{
    protected
        $_url,
        $_temporarily = true;

    /**
     * @param string|Url $url
     */
    public function __construct($url)
    {
        $this->setUrl($url);
    }

    public function send()
    {
        $this->setStatus($this->getTemporarily() ? 302 : 301);
        $this->setHeaders([
            "Location: " . $this->getUrl()
        ]);
        parent::send();
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->_url;
    }

    /**
     * @param string|Url $url
     */
    public function setUrl($url)
    {
        $this->_url = (string)$url;
    }

    /**
     * @return boolean
     */
    public function getTemporarily()
    {
        return $this->_temporarily;
    }

    /**
     * true, если переадресация временная
     * @param boolean $temporarily
     */
    public function setTemporarily($temporarily)
    {
        $this->_temporarily = $temporarily;
    }
}