<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 21.09.2015
 * Time: 16:12
 */

namespace Dcms\System;


use Dcms\Helpers\Json;
use Dcms\Helpers\Url;

/**
 * Запрос от клиента.
 *
 * Class Request
 * @package Dcms\System
 */
final class Request
{
    protected $_path_vars;
    private $_request_url;

    /**
     * @param null|string $request_url
     */
    function __construct($request_url = null)
    {
        $this->_request_url = $request_url;
    }

    /**
     * @return Url
     */
    public function getUrl()
    {
        return new Url($this->_request_url);
    }

    /**
     * @return string
     */
    public function getMethod()
    {
        return $_SERVER['REQUEST_METHOD'];
    }

    /**
     * Ожидаемый тип контента
     * @return string
     */
    public function getAcceptType()
    {
        $isJson = 0;
        $isHtml = 0;

        $accepts = explode(',', $_SERVER['HTTP_ACCEPT']);

        foreach ($accepts AS $accept) {
            list($type, $q) = explode(';', $accept); // todo: реализовать q
            switch (trim($type)) {
                case "application/json":
                case "text/json":
                    $isJson = 1;
                    break;
                case "text/html":
                case "application/xhtml+xml":
                case "application/xml":
                    $isHtml = 1;
            }
        }

        if ($isJson > $isHtml)
            return 'json';
        return 'html';
    }

    /**
     * @return mixed|null
     */
    public function getData()
    {
        list($type_without_content) = explode(';', $_SERVER["CONTENT_TYPE"]);
        switch ($type_without_content) {
            case "multipart/form-data":
            case "application/x-www-form-urlencoded":
                return $this->_getPostData();
            case "application/json":
                return $this->_getJsonData();

        }
        return null;
    }

    protected function _getPostData()
    {
        return $_POST;
    }

    protected function _getJsonData()
    {
        $inputJSON = file_get_contents('php://input');
        return Json::parse($inputJSON);
    }

    /**
     * @return string[]
     */
    public function getPathVariables()
    {
        return $this->_path_vars;
    }

    /**
     * @param string []
     */
    public function setPathVariables($path_variables)
    {
        $this->_path_vars = $path_variables;
    }

    /**
     * Возвращает значение переменной из пути
     * @param $string
     * @return null|string
     */
    public function getPathVariable($string)
    {
        if (!array_key_exists($string, $this->_path_vars)) {
            return null;
        }
        return $this->_path_vars[$string];
    }
}