<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 15:45
 */

namespace Dcms\System;

/**
 * Реестр для хранения глобальных объектов
 * Class Registry
 * @package Dcms\System
 */
class Registry
{
    private static $container = array();

    public static function set($key, $value)
    {   // Проверим наличие элемента в контейнере
        if(!isset(self::$container[$key]))
            self::$container[$key] = $value;
        else
            trigger_error('Variable '. $key .' already defined', E_USER_WARNING);
    }

    public static function get($key)
    {
        if (!array_key_exists($key, self::$container))
            return null;
        return self::$container[$key];
    }

}