<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 18:16
 */

namespace Dcms\System\Packages\Models;


use Dcms\Helpers\Text;
use Dcms\System\Taxonomy;
use Dcms\Ui\Page;
use Dcms\Ui\Ui;

abstract class Theme extends Package
{

    /**
     * Заполнение страницы настроек
     * @param Page $page
     * @return bool
     */
    public function fillSettingsUi(Page $page)
    {
        return false;
    }

    /**
     * Отправка заголовков
     */
    public function sendHeaders()
    {
        header('Cache-Control: no-store, no-cache, must-revalidate', true);
        header('Expires: ' . date('r'), true);
        header('X-UA-Compatible: IE=edge', true); // отключение режима совместимости в осле
        header('Content-Type: text/html; charset=utf-8', true);
    }

    /**
     * @param Taxonomy $taxonomy
     * @return string
     */
    public function renderMenu(Taxonomy $taxonomy)
    {
        $html = '<ul>' . PHP_EOL;
        foreach ($taxonomy->getItems() AS $item) {
            $name = Text::toValue($item->getName());
            $url = Text::toValue($item->getUrl());
            $html .= "<li><a href='{$url}'>{$name}</a></li>" . PHP_EOL;
        }
        $html .= '</ul>' . PHP_EOL;
        return $html;
    }

    public function renderSection()
    {

    }
}