<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 24.09.2015
 * Time: 17:29
 */

namespace Dcms\System\Packages\Models;


use Dcms\System\Request;

class ModuleMapping
{
    /**
     * @var ModuleMap[]
     */
    protected $_mapping = [], $_module_name;

    public function __construct($config)
    {
        $this->_module_name = $config['name'];
        if (array_key_exists('mapping', $config)) {
            $this->setMapping($config['mapping']);
        }
    }

    public function setMapping($map_config)
    {
        $this->_mapping = [];
        foreach ($map_config AS $map) {
            $this->_mapping[] = new ModuleMap([
                "Method" => $map['method'],
                "Url" => $map['url'],
                "Execute" => $map['execute'],
                "ModuleName" => $this->_module_name
            ]);
        }
    }

    /**
     * @param Request $request
     * @return ModuleMap[]
     */
    public function getMapsByRequest(Request $request)
    {
        $maps = [];
        foreach ($this->_mapping AS $map) {
            if ($map->hasExecuteRequest($request)) {
                $maps[] = $map;
            }
        }
        return $maps;
    }

}