<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 15:35
 */

namespace Dcms\System;


use Dcms\System\Packages\Modules;
use Dcms\System\Packages\Plugins;
use Dcms\System\Packages\Themes;
use Dcms\System\Packages\Widgets;
use Modules\Installer\Classes\SettingsToInstall;

abstract class Core
{
    private static $initialized = false;
    private static $start_time = null;

    public static function init($config)
    {
        if (self::$initialized)
            throw new \Exception('Core initialized');
        self::$start_time = microtime(true);

        if (!class_exists('pdo'))
            throw new \Exception(__("Отсутствует драйвер PDO"));

        if (array_key_exists('database', $config)) {
            Registry::set('Db', new Db($config['database']));
            Registry::set('Settings', new Settings(self::getDb()));
        } else {
            if (array_key_exists('installing', $config) && $config['installing']) {
                Registry::set('Settings', new SettingsToInstall());
            }
        }

        Registry::set('Config', $config);

        self::$initialized = true;
    }

    /**
     * @return Db
     */
    public static function getDb()
    {
        return Registry::get('Db');
    }

    /**
     * @return Settings
     */
    public static function getSettings()
    {
        return Registry::get('Settings');
    }

    /**
     * @return array
     */
    public static function getConfig()
    {
        return Registry::get('Config');
    }

    /**
     * @return Plugins
     */
    public static function getPlugins()
    {
        $plugins = Registry::get('Plugins');
        if (!$plugins) {
            $plugins = new Plugins();
            Registry::set('Plugins', $plugins);
        }
        return $plugins;
    }

    /**
     * Вызов хука
     * @param string $name
     * @param mixed $data
     */
    public static function hook($name, &$data)
    {
        self::getPlugins()->hook($name, $data);
    }

    /**
     * @return Themes
     */
    public static function getThemes()
    {
        $themes = Registry::get('Themes');
        if (!$themes) {
            $themes = new Themes();
            Registry::set('Themes', $themes);
        }
        return $themes;
    }

    /**
     * @return Widgets
     */
    public static function getWidgets()
    {
        $widgets = Registry::get('Widgets');
        if (!$widgets) {
            $widgets = new Widgets();
            Registry::set('Widgets', $widgets);
        }
        return $widgets;
    }

    /**
     * @return Modules
     */
    public static function getModules()
    {
        $modules = Registry::get('Modules');
        if (!$modules) {
            $modules = new Modules();
            Registry::set('Modules', $modules);
        }
        return $modules;
    }

    public static function getIsInstalled()
    {
        return self::getDb() instanceof \PDO;
    }

    /**
     * Возвращает время, прошедшее с момента инициализации
     * @param int $precision
     * @return float
     */
    public static function getElapsedTime($precision = 3)
    {
        return round(microtime(true) - self::$start_time, $precision);
    }
}