<?php
use Dcms\System\Core;
use Dcms\System\Request;
use Dcms\System\Responses\Redirect;
use Dcms\System\Responses\Response;
use Dcms\System\Responses\ResponseHtml;
use Dcms\System\Responses\ResponseJson;
use Dcms\Ui\Html;
use Dcms\Ui\Page;

try {
    require 'sys/init.php';

    $request = new Request();

    try {
        $result = Core::getModules()->executeRequest($request);

        if ($result instanceof Redirect) {
            $result->send();
            exit; // только для понимания. в send прерывается выполнение скрипта
        }

        if (!($result instanceof Response)) {
            $response = new Response();
            $response->setContent($result);
            $result = $response;
        }

        $result->send($request->getAcceptType() == 'json');

        exit; // только для понимания. в send прерывается выполнение скрипта

    } catch (Exception $e) {
        // если исключение упало в модуле, то отображаем страницу с ошибкой
        //Core::hook('Core:module_exception', $e);

        if ($request->getAcceptType() == 'json') {
            $response = new ResponseJson(["Status" => 500, "Content" => [
                "Message" => $e->getMessage()
            ]]);
            $response->send();
        } else {
            $page = new Page([
                "Title" => __("Внутренняя ошибка сервера"),
                "Items" => [
                    new Html('<pre>' . $e->getMessage() . PHP_EOL . $e->getTraceAsString() . '</pre>')
                ]
            ]);
            $response = new ResponseHtml([
                "Status" => 500,
                "Content" => $page->render()
            ]);
            $response->send();
        }
    }
} catch (Exception $e) {
    // если падает не в модуле
    http_response_code(500);
    header("Content-Type: text/plain");
    echo $e->getMessage() . PHP_EOL;
    echo $e->getTraceAsString();
}