<?php
$title = 'Добавить файл';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active) && $sys['modules']['shop'] == 1 && SellingAllowed($user)) {

    echo '<div class="title">Добавить файл</div>';

    if ($count_shop_kat == 0) {
        echo '<div class="menu">Категорий нет!</div>';
    } else {
		
		SmilesAndBB();
		
        if (isset($_POST['submit'])) {
            $error = '';
            if ($sys['modules']['wmid_sell'] == 1 && (!$user['wmid'] || !$user['wmr']) && $sys['payment']['wmr'] && $sys['payment']['hash']) {
                $error.= '<a href="/settings/wmid">Подтвердите реквизиты</a>, чтобы была возможность добавлять файлы!<br/>';
            } else {
                if (empty($_POST['name'])) {
                    $error.= 'Введите название файла!<br/>';
                }
                elseif (mb_strlen($_POST['name']) < 5 || mb_strlen($_POST['name']) > 250) {
                    $error.= 'Название должно содержать от 5 до 250 символов!<br/>';
                }
                if (empty($_POST['text'])) {
                    $error.= 'Введите описание файла!<br/>';
                }
                elseif (mb_strlen($_POST['text']) < 15 || mb_strlen($_POST['text']) > 15000) {
                    $error.= 'Описание должно содержать от 15 до 15000 символов!<br/>';
                }
                if (count(tagSearch($_POST['tags'])) > $sys['system']['stags']) {
                    $error.= 'Максимальное количество тегов - '.$sys['system']['stags'].'!<br/>';
                }
                if (empty($_POST['kat'])) {
                    $error.= 'Выберите категорию файла!<br/>';
                }
                if (!empty($_POST['release'])) {
                    $release = validateDate($_POST['date'] . $_POST['time'], 'Y-m-dH:i');
                    if (empty($_POST['date']) || empty($_POST['time'])) {
                        $error.= 'Укажите дату и время релиза!<br/>';
                    }
                    elseif (!$release) {
                        $error.= 'Некорректный формат даты релиза!<br/>';
                    }
                    elseif ($release < time()) {
                        $error.= 'Дата релиза не может быть в прошедшем времени!<br/>';
                    }
                    if (!empty($_POST['comment']) && mb_strlen($_POST['comment']) > 75) {
                        $error.= 'Примечание должно содержать не более 75 символов!<br/>';
                    }
                }
                if (empty($_POST['free']) || $sys['modules']['shop_free'] == 0) {
                    if (empty($_POST['cena'])) {
                        $error.= 'Введите стоимость файла!<br/>';
                    }
                    elseif ($_POST['cena'] < $sys['system']['scena']) {
                        $error.= 'Минимальная стоимость файла - '.rub($sys['system']['scena']).'!<br/>';
                    }
                    if ($_POST['uid'] != 0 && !user($_POST['uid'])) {
                        $error.= 'Пользователь с таким ID не найден в системе!<br/>';
                    }
                    elseif ($_POST['uid'] == $user['id']) {
                        $error.= 'Нельзя продавать самому себе!<br/>';
                    }
                }
                if (!file_exists($_FILES['filename']['tmp_name'])) {
                    $error.= 'Вы не выбрали файл!<br/>';
                }
                elseif (!BeforeUpload::AttachArchive($_FILES['filename'])) {
                    $error.= 'Неверный тип файла: разрешено загружать только ZIP/RAR/7Z!<br/>';
                }
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                $time = !empty($_POST['release']) ? $release : time();
                $comment = !empty($_POST['release']) ? $_POST['comment'] : '';
                $free = (!empty($_POST['free']) && $sys['modules']['shop_free'] == 1 ? 1 : 0);
                $uid = intval($_POST['uid']);
                $col = $uid == 0 ? intval(abs($_POST['col'])) : 1;
                $cena = floatval($_POST['cena']);
                $limit = $col == 0 ? 0 : 1;
                if ($free == 1)
                    $uid = $col = $cena = $limit = 0;
                $status = ($adm_id == 1 || $sys['modules']['mod_p'] == 1) ? 1 : 3;

                $stmt = $connect->prepare("insert into `shop` set `time` = ?, `comment` = ?, `seller` = ?, `name` = ?, `text` = ?, `tags` = ?, `kat` = ?, `cena` = ?, `col` = ?, `limit` = ?, `uid` = ?, `free` = ?, `status` = ?");

                if ($stmt->execute(array($time, $comment, $user['id'], $_POST['name'], $_POST['text'], $_POST['tags'], $_POST['kat'], $cena, $col, $limit, $uid, $free, $status))) {

                    $lid = $connect->LastInsertId();
                    $files = $lid."_".md5_file($_FILES['filename']['tmp_name'])."_".$_FILES['filename']['name'];
                    $full_path = $_SERVER["DOCUMENT_ROOT"]."/files/load/".$files;

                    move_uploaded_file($_FILES['filename']['tmp_name'], $full_path);
                    chmod($full_path, 0444);

                    if ($uid != 0)
                        notification('В загрузках опубликован [url='.ROOT.'/load/product/'.$lid.']файл[/url] специально для Вас!', $uid);

                    header('Location: /load/product/'.$lid);

                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }
        }

        echo '<div class="menu">
        <form action="" method="POST" enctype="multipart/form-data">
        Название файла [5-250]:<br/><input type="text" name="name"><br/>
        Описание файла [15-15000]:<br/><textarea data-select-range id="message" name="text" rows="5" cols="30"></textarea><br/>
        Теги (через запятую):<br/><input type="text" name="tags"><br/>
        Категория:<br/><select name="kat">';

        $sql = $connect->query("select * from `kat` where `type` = '1' order by `id` desc")->fetchAll();

        foreach ($sql as $kat_row) {

            echo '<option value="'.$kat_row['id'].'">'.$kat_row['name'].'</option>';

        }

        echo '</select><br/>
        Релиз:<br/><select id="release" name="release">
        <option selected value="0">Прямо сейчас</option>
        <option value="1">Позже</option>
        </select><br/>
        <div id="latter" class="wa-hidden">
        Дата релиза: <small>ГГГГ-ММ-ДД</small><br/><input type="date" name="date"><br/>
        Время релиза: <small>ЧЧ:ММ</small><br/><input type="text" name="time" value="00:00"><br/>
        Примечание [75]:<br/><input type="text" name="comment"><br/>
        </div>
        '.($sys['modules']['shop_free'] == 1 ?
        'Тип:<br/><select id="free" name="free">
        <option selected value="0">Платный</option>
        <option value="1">Бесплатный</option>
        </select><br/>' : '').'
        <div id="paid">
        Стоимость файла:<br/><input type="text" name="cena"><br/>
        Количество копий (0 - без ограничений):<br/><input type="text" name="col" value="0"><br/>
        ID покупателя (0 - доступен всем):<br/><input type="text" name="uid" value="0"><br/>
        </div>
        Файл:<br/><input type="file" name="filename"><br/>
        <input type="submit" name="submit" value="Добавить файл">
        </form></div>';

        ?>
        <script>
            $(function() {
                var release = $('#release');
                release.change(function() {
                    if (release.val() == 1) {
                        $('#latter').show();
                    } else {
                        $('#latter').hide();
                    }
                });
                var free = $('#free');
                free.change(function() {
                    if (free.val() == 1) {
                        $('#paid').hide();
                    } else {
                        $('#paid').show();
                    }
                });
            });
        </script>
        <?

    }

    echo '<div class="forlink"><a href="/load/my" class="links"><img src="/img/myshop.png" alt="myshop">Мои файлы</a></div>';

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>