/**
 * Created by pavlovd on 29.09.2015.
 */
(function () {
    angular.module('app.Listing', [])
        .directive('ajaxListing', function () {
            return {
                restrict: 'A',
                scope: {
                    formId: '@',
                    url: '@ajaxListing'
                },
                link: function (scope, element, attr) {
                    scope.replaceHtml = function (html) {
                        var content = angular.element(html);
                        element.empty().append(content.children());
                    }
                },
                controller: function ($scope, $rootScope, $http) {
                    var handler = $rootScope.$on('formSubmitted', function (event, formId, response) {
                        if ($scope.formId === formId) {
                            $scope.update();
                        }
                    });
                    $scope.$on('destroy', handler);


                    $scope.update = function () {
                        if (!$scope.url)
                            return;

                        $http.get($scope.url, {headers: {Accept: "text/html"}})
                            .success(function (response) {
                                $scope.replaceHtml(response);
                            });
                    };
                }
            }
        })
})();