<?php
/**
 * @var \Dcms\Ui\RichText $model
 */

use Dcms\Helpers\Text;

$attributes = array(
    'name' => $model->getName(),
    'class' => 'ui_form_rich_text'
);

if ($model->getEnabled()) {
    $attributes['enabled'] = 'enabled';
} else {
    $attributes['disabled'] = 'disabled';
}

$attributes_seq = array();
foreach ($attributes AS $key => $value) {
    $attributes_seq[] = $key . '="' . Text::toValue($value) . '"';
}

$code = '<div id="' . $model->getId() . '" class="' . join(' ', $model->_getAllClasses()) . '">';
if ($model->hasTitle()) {
    $code .= '<span>' . Text::toOutput($model->getTitle()) . '</span>';
}
$code .= '<textarea ' . join(' ', $attributes_seq) . '>' . Text::toValue($model->getValue()) . '</textarea>';
$code .= '</div>';

echo $code;