<?php
/**
 * @var \Dcms\Ui\Input $model
 */
use Dcms\Helpers\Text;

$attributes = array(
    'type' => Text::toValue($model->getType()),
    'name' => Text::toValue($model->getName()),
    'value' => Text::toValue($model->getValue())
);

if ($model->hasSize()) {
    $attributes['size'] = (int)$model->getSize();
}

if ($model->hasMaxLength()) {
    $attributes['maxlength'] = (int)$model->getMaxLength();
}

if ($model->getEnabled()) {
    //$attributes['enabled'] = 'enabled';
} else {
    $attributes['disabled'] = 'disabled';
}

$attributes_seq = array();
foreach ($attributes AS $key => $value) {
    $attributes_seq[] = $key . '="' . Text::toValue($value) . '"';
}

$hidden = $model->getType() === 'hidden' ? 'style="display:none"' : '';

?>
<div id="<?= $model->getId() ?>" class="<?= join(' ', $model->_getAllClasses()) ?>" <?= $hidden ?>>
    <label>
        <span><?= Text::toOutput($model->getTitle()) ?></span>
        <input <?= join(' ', $attributes_seq) ?>/>
    </label>
</div>