<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 19:19
 */

namespace Themes\System;


use Dcms\Helpers\Text;
use Dcms\System\Taxonomy;

class Theme extends \Dcms\System\Packages\Models\Theme
{
    /**
     * @param Taxonomy $taxonomy
     * @return string
     */
    public function renderMenu(Taxonomy $taxonomy)
    {
        $html = "";
        foreach ($taxonomy->getItems() AS $item) {
            $name = Text::toValue($item->getName());
            $url = Text::toValue($item->getUrl());
            $html .= "<div class='menu_item'><a href='{$url}'>{$name}</a>";

            if ($item->getItems()) {
                $html .= '<div class="drop_menu">' . $this->renderMenu($item) . '</div>';
            }

            $html .= "</div>";
        }
        return $html;
    }


}