### Modules ###

Модули - обработчики запросов пользователей.


Имя класса должно быть Module.
Класс модуля должен наследовать класс \Dcms\System\Packages\Models\Module

Для того, чтобы модуль стал обработчиком определенного запроса, необходимо указать это в конфиге в параметре (массиве) **mapping**
Каждый метод, который должен обрабатывать запросы должен принимать первым параметром объект класса **Request**
Класс может возвращать объект классов Request, Response, Ui или выводить содержимое страницы через echo|print

* Request - передает другой запрос для обработки соответствующим моделем
* Response - возвращает произвольное содержимое с произвольными заголовками пользователю (браузеру)
* Ui|Page - Возвращает модель с содержимым страницы или страницу целиком. Перед отправкой на клиент модели рендерятся в HTML с использованием шаблонов темы оформления.
* echo|print - содержимое обрамляется в шаблон Page и отправляется на клиент


Пример:
---
```php
namespace Modules\Example;


use Dcms\System\Request;
use Dcms\System\Responses\Response;

class Module extends \Dcms\System\Packages\Models\Module
{

    /**
     * @param Request $request
     */
    public function example_method(Request $request)
    {
        
    }
}
```

Пример конфига:
---
```
{
  "name": "Example",
  "version": "0.0.1",
  "type": "module",
  "mapping": [
    {
      "method": "GET",
      "url": "/example/",
      "execute": "example_method"
    }
  ]
}
```
В примере выше все запросы GET /example/ будут обрабатываться методом **example_method** модуля **Example**


Пример мапинга с переменными в Url:
---

```
{
      "method": "GET",
      "url": "/example/{param1}/{param2}/",
      "execute": "example_method"
}
```
В примере выше запрос GET /example/var1/var2/ будет обработан методом **example_method** модуля **Example**.
Для получения переменных из Url у объекта **Request** есть метод **getPathVariables**.
В данном случае, метод **getPathVariables** вернет массив [0 => "var1", 1 => "var2", "param1" => "var1", "param2" => "var2"]

