<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 25.09.2015
 * Time: 16:07
 */

namespace Modules\Installer;


use Dcms\Helpers\Url;
use Dcms\System\Core;
use Dcms\System\Request;
use Dcms\System\Responses\Redirect;
use Dcms\Ui\Page;

class Module extends \Dcms\System\Packages\Models\Module
{
    public function redirect(Request $request)
    {
        return new Redirect('/installer/check');
    }

    public function installer(Request $request)
    {
        $state = $request->getPathVariable('state');

        switch ($state) {
            case 'check':
            default:
                return $this->_check($request);
        }
    }

    protected function _check(Request $request)
    {
        $page = new Page();
        $page->setTitle(__("Установка. Проверка сервера."));

        if (Core::getIsInstalled()) {
            //return new Redirect('/');
        }

        return $page;
    }
}