<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 29.09.2015
 * Time: 20:04
 */

namespace Modules\Demo;


use Dcms\Helpers\Url;
use Dcms\System\Request;
use Dcms\Ui\Form;
use Dcms\Ui\Html;
use Dcms\Ui\Input;
use Dcms\Ui\Listing;
use Dcms\Ui\Page;
use Dcms\Ui\Post;

class Module extends \Dcms\System\Packages\Models\Module
{
    public function demo(Request $request)
    {
        $page = new Page([
            "Title" => __("Заголовок"),
            "Items" => [
                $form = new Form([
                    "Url" => new Url(null),
                    "Items" => [
                        new Input([
                            "Title" => __("Инпут")
                        ]),
                        new Input([
                            "Type" => "submit",
                            "Value" => __("Кнопка")
                        ])
                    ]
                ]),
                $listing = new Listing([
                    "Title" => __("Список")
                ])
            ]
        ]);

        for ($i = 0; $i < 5; $i++) {
            $listing->addItem(new Post([
                "Title" => __("Заголовок поста"),
                "Items" => [
                    new Html("content")
                ],
                "BottomHtml" => "bottom content"
            ]));
        }

        return $page;
    }
}