-- --------------------------------------------------------
-- Хост:                         127.0.0.1
-- Версия сервера:               5.5.41-log - MySQL Community Server (GPL)
-- ОС Сервера:                   Win32
-- HeidiSQL Версия:              9.3.0.4984
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Дамп структуры для таблица dcms8.comments
DROP TABLE IF EXISTS `comments`;
CREATE TABLE IF NOT EXISTS `comments` (
  `id`        INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `id_parent` INT(10) UNSIGNED          DEFAULT NULL,
  `subject`   VARCHAR(50)      NOT NULL,
  `id_user`   INT(10) UNSIGNED NOT NULL,
  `text`      TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `subject` (`subject`),
  KEY `FK_comments_comments` (`id_parent`),
  KEY `FK_comments_users` (`id_user`),
  CONSTRAINT `FK_comments_comments` FOREIGN KEY (`id_parent`) REFERENCES `comments` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `FK_comments_users` FOREIGN KEY (`id_user`) REFERENCES `users` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE
)
  ENGINE = InnoDB
  AUTO_INCREMENT = 23
  DEFAULT CHARSET = utf8
  COMMENT = 'Комментарии';

-- Дамп данных таблицы dcms8.comments: ~20 rows (приблизительно)
DELETE FROM `comments`;
/*!40000 ALTER TABLE `comments` DISABLE KEYS */;
INSERT INTO `comments` (`id`, `id_parent`, `subject`, `id_user`, `text`) VALUES
  (3, NULL, 'chat', 1, 'test'),
  (4, NULL, 'chat', 1, 'вапрыкео'),
  (5, NULL, 'chat', 1, 'рангдаенд'),
  (6, NULL, 'chat', 1, 'рангдаенд'),
  (7, NULL, 'chat', 1, 'рангдаенд'),
  (8, NULL, 'chat', 1, 'рангдаенд'),
  (9, NULL, 'chat', 1, 'рангдаенд'),
  (10, NULL, 'chat', 1, 'пренлу6д'),
  (11, NULL, 'chat', 1, 'пренлу6д'),
  (12, NULL, 'chat', 1, 'пренлу6д'),
  (13, NULL, 'chat', 1, 'пренлу6д'),
  (14, NULL, 'chat', 1, 'панлу6'),
  (15, NULL, 'chat', 1, 'панлу6'),
  (16, NULL, 'chat', 1, 'панлу6'),
  (17, NULL, 'chat', 1, 'панлу6'),
  (18, NULL, 'chat', 1, 'панлу6'),
  (19, NULL, 'chat', 1, 'tkftyl'),
  (20, NULL, 'chat', 1, 'tkftyl'),
  (21, NULL, 'chat', 1, 'vghfyl'),
  (22, NULL, 'chat', 1, 'yu лаендк 7кенд 67');
/*!40000 ALTER TABLE `comments` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.packages
DROP TABLE IF EXISTS `packages`;
CREATE TABLE IF NOT EXISTS `packages` (
  `type` enum('plugin','theme','widget','module') NOT NULL COMMENT 'Тип пакета',
  `name` varchar(32) NOT NULL COMMENT 'Имя пакета',
  `version` varchar(32) NOT NULL,
  `installed` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Флаг. Установлен ли пакет',
  `enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Флаг. Включен ли пакет',
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Флаг. Системный пакет.',
  `config_json` mediumtext NOT NULL,
  PRIMARY KEY (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Пакеты';

-- Дамп данных таблицы dcms8.packages: ~7 rows (приблизительно)
DELETE FROM `packages`;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` (`type`, `name`, `version`, `installed`, `enabled`, `system`, `config_json`) VALUES
  ('plugin', 'Example', '0.0.1', 1, 1, 0,
   '{"name":"Example","version":"0.0.1","type":"plugin","mapping":[{"hook_name":"","execute":"method_name"}]}'),
  ('theme', 'System', '0.0.1', 1, 1, 1,
   '{"name":"System","type":"theme","version":"0.0.1","system":true,"parent":"","dependencies":[],"resources":{"css":["resources/app/*.css"],"js":["resources/libs/jquery/*.js","resources/libs/angular/angular-1.4.6/angular.js","resources/app/*.js"]},"templates_path":"Views","sections":{"right_column":"Правая колонка","header":"Под заголовком","footer":"Низ страницы"},"menus":{"main_menu":"Главное меню"}}'),
  ('module', 'Chat', '0.0.1', 1, 1, 0,
   '{"name":"Chat","version":"0.0.1","type":"module","mapping":[{"method":"GET","url":"/chat/","execute":"chatPage"}]}'),
  ('module', 'Comments', '0.0.1', 1, 1, 0,
   '{"name":"Comments","version":"0.0.1","type":"module","mapping":[{"method":"GET","url":"/api/comments/{subject}","execute":"get"},{"method":"GET","url":"/api/comments/{subject}/listing","execute":"getListing"},{"method":"POST","url":"/api/comments/{subject}","execute":"post"}]}'),
  ('module', 'Demo', '0.0.1', 1, 1, 0,
   '{"name":"Demo","version":"0.0.1","type":"module","mapping":[{"url":"/demo/","method":"GET","execute":"demo"}]}'),
  ('module', 'Installer', '0.0.1', 1, 1, 1,
   '{"name":"Installer","version":"0.0.1","type":"module","system":true,"mapping":[{"url":"{**}","method":"GET","execute":"redirect"},{"url":"/installer/{state}","method":"GET","execute":"installer"}]}'),
  ('module', 'MainPage', '0.0.1', 1, 1, 0,
   '{"name":"MainPage","version":"0.0.1","type":"module","mapping":[{"url":"/","method":"GET","execute":"main"}]}');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.permissions
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL COMMENT 'Название разрешения',
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Системное (создано автоматически)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Разрешения';

-- Дамп данных таблицы dcms8.permissions: ~0 rows (приблизительно)
DELETE FROM `permissions`;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.permissions_of_roles
DROP TABLE IF EXISTS `permissions_of_roles`;
CREATE TABLE IF NOT EXISTS `permissions_of_roles` (
  `id_permission` int(10) unsigned NOT NULL,
  `id_role` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id_permission`,`id_role`),
  KEY `FK_permissions_of_roles_roles` (`id_role`),
  CONSTRAINT `FK_permissions_of_roles_permissions` FOREIGN KEY (`id_permission`) REFERENCES `permissions` (`id`),
  CONSTRAINT `FK_permissions_of_roles_roles` FOREIGN KEY (`id_role`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Разрешения роли';

-- Дамп данных таблицы dcms8.permissions_of_roles: ~0 rows (приблизительно)
DELETE FROM `permissions_of_roles`;
/*!40000 ALTER TABLE `permissions_of_roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions_of_roles` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.repository_packages
DROP TABLE IF EXISTS `repository_packages`;
CREATE TABLE IF NOT EXISTS `repository_packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('plugin','theme','widget','module') NOT NULL COMMENT 'Тип пакета',
  `name` varchar(32) NOT NULL COMMENT 'Имя пакета',
  `id_user` int(10) unsigned DEFAULT NULL COMMENT 'Создатель пакета',
  PRIMARY KEY (`id`),
  KEY `FK_repository_packages_users` (`id_user`),
  CONSTRAINT `FK_repository_packages_users` FOREIGN KEY (`id_user`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='Пакеты';

-- Дамп данных таблицы dcms8.repository_packages: ~0 rows (приблизительно)
DELETE FROM `repository_packages`;
/*!40000 ALTER TABLE `repository_packages` DISABLE KEYS */;
/*!40000 ALTER TABLE `repository_packages` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.repository_packages_dependencies
DROP TABLE IF EXISTS `repository_packages_dependencies`;
CREATE TABLE IF NOT EXISTS `repository_packages_dependencies` (
  `id_package_version` int(10) unsigned NOT NULL COMMENT 'Версия пакета',
  `id_package_dependency` int(10) unsigned NOT NULL COMMENT 'Зависимый пакет',
  KEY `FK_repository_packages_dependencies_repository_packages_versions` (`id_package_version`),
  KEY `FK_repository_packages_dependencies_repository_packages` (`id_package_dependency`),
  CONSTRAINT `FK_repository_packages_dependencies_repository_packages` FOREIGN KEY (`id_package_dependency`) REFERENCES `repository_packages` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_repository_packages_dependencies_repository_packages_versions` FOREIGN KEY (`id_package_version`) REFERENCES `repository_packages_versions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Зависимости версии пакета';

-- Дамп данных таблицы dcms8.repository_packages_dependencies: ~0 rows (приблизительно)
DELETE FROM `repository_packages_dependencies`;
/*!40000 ALTER TABLE `repository_packages_dependencies` DISABLE KEYS */;
/*!40000 ALTER TABLE `repository_packages_dependencies` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.repository_packages_versions
DROP TABLE IF EXISTS `repository_packages_versions`;
CREATE TABLE IF NOT EXISTS `repository_packages_versions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_package` int(10) unsigned NOT NULL DEFAULT '0',
  `version` varchar(50) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_repository_packages_versions_repository_packages` (`id_package`),
  CONSTRAINT `FK_repository_packages_versions_repository_packages` FOREIGN KEY (`id_package`) REFERENCES `repository_packages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Версии пакетов';

-- Дамп данных таблицы dcms8.repository_packages_versions: ~0 rows (приблизительно)
DELETE FROM `repository_packages_versions`;
/*!40000 ALTER TABLE `repository_packages_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `repository_packages_versions` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.roles
DROP TABLE IF EXISTS `roles`;
CREATE TABLE IF NOT EXISTS `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL COMMENT 'Имя роли',
  `system` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Системная роль (созданная пакетом)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Роли пользователей';

-- Дамп данных таблицы dcms8.roles: ~0 rows (приблизительно)
DELETE FROM `roles`;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.roles_of_users
DROP TABLE IF EXISTS `roles_of_users`;
CREATE TABLE IF NOT EXISTS `roles_of_users` (
  `id_role` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id_role`,`id_user`),
  KEY `FK_roles_of_users_users` (`id_user`),
  CONSTRAINT `FK_roles_of_users_roles` FOREIGN KEY (`id_role`) REFERENCES `roles` (`id`),
  CONSTRAINT `FK_roles_of_users_users` FOREIGN KEY (`id_user`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Роли пользователей';

-- Дамп данных таблицы dcms8.roles_of_users: ~0 rows (приблизительно)
DELETE FROM `roles_of_users`;
/*!40000 ALTER TABLE `roles_of_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles_of_users` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.settings
DROP TABLE IF EXISTS `settings`;
CREATE TABLE IF NOT EXISTS `settings` (
  `key` varchar(128) NOT NULL COMMENT 'Ключ',
  `value` longtext NOT NULL COMMENT 'Значение',
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Настройки';

-- Дамп данных таблицы dcms8.settings: ~0 rows (приблизительно)
DELETE FROM `settings`;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.taxonomy
DROP TABLE IF EXISTS `taxonomy`;
CREATE TABLE IF NOT EXISTS `taxonomy` (
  `id`        INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `id_parent` INT(10) UNSIGNED          DEFAULT NULL,
  `sort`      INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `name`      VARCHAR(50)      NOT NULL,
  `url`       VARCHAR(50)               DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_taxonomy_taxonomy` (`id_parent`),
  CONSTRAINT `FK_taxonomy_taxonomy` FOREIGN KEY (`id_parent`) REFERENCES `taxonomy` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE
)
  ENGINE = InnoDB
  AUTO_INCREMENT = 8
  DEFAULT CHARSET = utf8;

-- Дамп данных таблицы dcms8.taxonomy: ~7 rows (приблизительно)
DELETE FROM `taxonomy`;
/*!40000 ALTER TABLE `taxonomy` DISABLE KEYS */;
INSERT INTO `taxonomy` (`id`, `id_parent`, `sort`, `name`, `url`) VALUES
  (1, NULL, 0, 'Меню', NULL),
  (2, 1, 0, 'Главное меню', NULL),
  (3, 2, 0, 'Главная', '/'),
  (4, 2, 0, 'Чат', '/chat/'),
  (5, 2, 0, 'Меню пользователя', '/user/'),
  (6, 2, 0, 'Форум', '/forum/'),
  (7, 2, 0, 'DEMO', '/demo/');
/*!40000 ALTER TABLE `taxonomy` ENABLE KEYS */;


-- Дамп структуры для таблица dcms8.users
DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL COMMENT 'Отображаетмое имя пользователя',
  `email` varchar(64) DEFAULT NULL,
  `date_create` datetime NOT NULL COMMENT 'Дата создания аккаунта',
  `date_login` datetime NOT NULL COMMENT 'Дата последнего посещения',
  `password` blob NOT NULL COMMENT 'Пароль от аккаунта (обычно хэш, но может отсутствовать, если авторизация производится через сторонние сервисы)',
  PRIMARY KEY (`id`)
)
  ENGINE = InnoDB
  AUTO_INCREMENT = 2
  DEFAULT CHARSET = utf8
  COMMENT = 'Пользователи';

-- Дамп данных таблицы dcms8.users: ~1 rows (приблизительно)
DELETE FROM `users`;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `name`, `email`, `date_create`, `date_login`, `password`) VALUES
  (1, 'test_user', NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', _binary '');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;


-- Дамп структуры для представление dcms8.users_permissions
DROP VIEW IF EXISTS `users_permissions`;
-- Создание временной таблицы для обработки ошибок зависимостей представлений
CREATE TABLE `users_permissions` (
	`permission` VARCHAR(64) NOT NULL COMMENT 'Название разрешения' COLLATE 'utf8_general_ci',
	`role` VARCHAR(64) NOT NULL COMMENT 'Имя роли' COLLATE 'utf8_general_ci',
	`id` INT(10) UNSIGNED NOT NULL
) ENGINE=MyISAM;


-- Дамп структуры для представление dcms8.users_permissions
DROP VIEW IF EXISTS `users_permissions`;
-- Удаление временной таблицы и создание окончательной структуры представления
DROP TABLE IF EXISTS `users_permissions`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` VIEW `users_permissions` AS SELECT `p`.`name` AS `permission`, `r`.name AS role, `u`.`id` FROM `permissions` AS `p`
JOIN permissions_of_roles AS por ON por.id_permission = p.id
JOIN roles AS r ON por.id_role = r.id
JOIN roles_of_users AS rou ON rou.id_role = r.id
JOIN users AS u ON rou.id_user = u.id ;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
