<?php

namespace Dcms\Ui;

use Dcms\Helpers\Url;
use Dcms\Ui\Data\Link;

class Post extends Ui
{
    protected
        $_actions = [],
        $_icon_src = '',
        $_image_src = '',
        $_bottom_html = '',
        $_time = null,
        $_url = null,
        $_title = '',
        $_counter = null,
        $_checkbox = null,
        $_highlight = false,
        $_checkbox_checked = false;


    public function setImageSrc($src)
    {
        $this->_image_src = $src;
    }

    /**
     * @return string
     */
    public function getImageSrc()
    {
        return $this->_image_src;
    }

    public function setIconSrc($src)
    {
        $this->_icon_src = $src;
    }

    public function getIconSrc()
    {
        return $this->_icon_src;
    }

    /**
     * Добавляет HTML блок
     * @param string $content_html
     */
    public function addContentHtml($content_html)
    {
        $this->addItem(new Html($content_html));
    }

    /**
     * @param string $content_html
     */
    public function addContentHtmlBlock($content_html)
    {
        $this->addItem(new Html('<p>' . $content_html . '</p>'));
    }

    /**
     * @return string
     */
    public function getBottomHtml()
    {
        return $this->_bottom_html;
    }

    /**
     * @param string $bottom_html
     */
    public function setBottomHtml($bottom_html)
    {
        $this->_bottom_html = (string)$bottom_html;
    }

    /**
     * @return string
     */
    public function getTime()
    {
        return $this->_time;
    }

    /**
     * @param string $time
     */
    public function setTime($time)
    {
        $this->_time = $time;
    }

    /**
     * @return Url|null
     */
    public function getUrl()
    {
        return $this->_url;
    }

    /**
     * @param string|Url $url
     */
    public function setUrl($url)
    {
        $this->_url = new Url((string)$url);
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->_title;
    }

    /**
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->_title = $title;
    }

    /**
     * @return string
     */
    public function getCounter()
    {
        return $this->_counter;
    }

    /**
     * @param string $counter
     */
    public function setCounter($counter)
    {
        $this->_counter = $counter;
    }

    /**
     * @return string
     */
    public function getCheckbox()
    {
        return $this->_checkbox;
    }

    /**
     * Задает название параметра для checkbox.
     * Будет работать только внутри ui_form
     * @param string|null $checkbox
     */
    public function setCheckbox($checkbox)
    {
        $this->_checkbox = $checkbox;
    }

    /**
     * @return bool
     */
    public function getHighlight()
    {
        return $this->_highlight;
    }

    /**
     * @param bool $highlight
     */
    public function setHighlight($highlight)
    {
        $this->_highlight = (bool)$highlight;
    }

    /**
     * @param bool $checked
     */
    public function setCheckboxChecked($checked)
    {
        $this->_checkbox_checked = !!$checked;
    }

    /**
     * @return bool
     */
    public function getCheckboxChecked()
    {
        return $this->_checkbox_checked;
    }

    /**
     * @return Link[]
     */
    public function getActions()
    {
        return $this->_actions;
    }

    /**
     * @param Link[] $actions
     */
    public function setActions($actions)
    {
        $this->_actions = $actions;
    }

    /**
     * @param Link $action
     */
    public function addAction(Link $action)
    {
        $this->_actions[] = $action;
    }
}