<?php

namespace Dcms\Ui;

class Input extends Ui
{
    protected
        $_type = 'text',
        $_name = '',
        $_value = '',
        $_title = '',
        $_max_length = null,
        $_size = null,
        $_enabled = true;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->_name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->_name = $name;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->_value;
    }

    /**
     * @param string $value
     */
    public function setValue($value)
    {
        $this->_value = $value;
    }

    /**
     * @return bool
     */
    public function hasTitle()
    {
        return !!$this->_title;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->_title;
    }

    /**
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->_title = $title;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->_type;
    }

    /**
     * @param string $type
     */
    public function setType($type)
    {
        $this->_type = $type;
    }

    /**
     * @return bool
     */
    public function hasSize()
    {
        return !is_null($this->_size);
    }

    /**
     * @return int|null
     */
    public function getSize()
    {
        return $this->_size;
    }

    /**
     * @param int|null $size
     */
    public function setSize($size)
    {
        $this->_size = $size;
    }

    /**
     * @return boolean
     */
    public function getEnabled()
    {
        return $this->_enabled;
    }

    /**
     * @param boolean $enabled
     */
    public function setEnabled($enabled)
    {
        $this->_enabled = $enabled;
    }

    /**
     * return bool
     */
    public function hasMaxLength()
    {
        return !is_null($this->_max_length);
    }

    /**
     * @return null|int
     */
    public function getMaxLength()
    {
        return $this->_max_length;
    }

    /**
     * @param null|int $max_length
     */
    public function setMaxLength($max_length)
    {
        $this->_max_length = $max_length;
    }

}