<?php

namespace Dcms\Ui;

/**
 * Произвольный html код
 */
class Html extends Ui
{
    protected $_html;

    /**
     * @param array|string $config_or_html
     */
    public function __construct($config_or_html = null)
    {
        if (is_array($config_or_html)) {
            parent::__construct($config_or_html);
        } else {
            parent::__construct(["Html" => $config_or_html]);
        }
    }

    /**
     * @return string
     */
    public function getHtml()
    {
        return $this->_html;
    }

    /**
     * @param string $html
     */
    public function setHtml($html)
    {
        $this->_html = $html;
    }
}