<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 21.09.2015
 * Time: 21:23
 */

namespace Dcms\Ui\Data;


use Dcms\Helpers\Configurator;
use Dcms\Helpers\Url;

class Link extends Configurator
{
    protected
        $_url = '',
        $_text = '',
        $_selected = false;

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->_url;
    }

    /**
     * @param Url|string $url
     */
    public function setUrl($url)
    {
        $this->_url = (string)$url;
    }

    /**
     * @return string
     */
    public function getText()
    {
        return $this->_text;
    }

    /**
     * @param string $text
     */
    public function setText($text)
    {
        $this->_text = $text;
    }

    /**
     * @return bool
     */
    public function getSelected()
    {
        return $this->_selected;
    }

    /**
     * @param bool $selected
     */
    public function setSelected($selected)
    {
        $this->_selected = $selected;
    }
}