<?php

namespace Dcms\Ui;

class Captcha extends Input
{
    protected
        $_session = '',
        $_name = 'captcha';

    public function __construct($config = [])
    {
        $this->setTitle(__('Введите число с картинки'));
        $this->setSession(captcha::gen());
        parent::__construct($config);
    }

    /**
     * @return string
     */
    public function getSession()
    {
        return $this->_session;
    }

    /**
     * @param string $session
     */
    public function setSession($session)
    {
        $this->_session = $session;
    }

    public function getContentHtml()
    {
        $attributes = array(
            'type' => 'number',
            'name' => $this->getName(),
            'value' => $this->getValue(),
            'class' => 'ui_form_input',
            'maxlength' => 5
        );

        if ($this->hasSize()) {
            $attributes['size'] = $this->getSize();
        }

        if ($this->hasMaxLength()) {
            $attributes['maxlength'] = $this->getMaxLength();
        }


        $attributes_seq = array();
        foreach ($attributes AS $key => $value) {
            $attributes_seq[] = $key . '="' . text::toValue($value) . '"';
        }
        $code = '<span id="' . $this->getId() . '" class="ui_form_input">';
        if ($this->hasTitle()) {
            $code .= '<span>' . text::toOutput($this->getTitle()) . '</span>';
        }
        $code .= '<img src="/pages/captcha.php?captcha_session=' . $this->getSession() . '" alt="" /><br />';
        $code .= '<input type="hidden" name="captcha_session" value="' . $this->getSession() . '" />';
        $code .= '<input ' . join(' ', $attributes_seq) . ' />';
        $code .= '</span>';

        if ($this->getIsBlock()) {
            $code .= '<br />';
        }

        return $code;
    }
}