<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 23.09.2015
 * Time: 21:58
 */

namespace Dcms\System\Responses;


use Dcms\Helpers\Json;

/**
 * Ответ с заголовком Content-Type: json
 * Class ResponseJson
 * @package Dcms\System\Responses
 */
class ResponseJson extends Response
{
    protected $_headers = [
        "Content-Type: application/json"
    ];

    public function send($asJson = false)
    {
        http_response_code($this->_status);
        foreach ($this->_headers AS $header) {
            header($header, true);
        }

        exit(Json::stringify($this->_content));
    }
}