<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 15:05
 */

namespace Dcms\System\Packages;


use Dcms\System\Packages\Models\Plugin;
use Dcms\System\Packages\Models\PluginHook;

class Plugins extends Packages
{
    /**
     * Проверка, будет ли плагин обрабатывать указанный хук
     * @param string $plugin_name
     * @param string $hook_name
     * @return bool
     */
    public function isProcessedHookPlugin($plugin_name, $hook_name)
    {
        return true;
    }


    /**
     * Возвращает массив инстансов плагинов для обработки хука
     * @param string $hook_name
     * @return Plugin[string]
     */
    protected function _getActivePluginsByHookName($hook_name)
    {
        $all_plugins_list = $this->getList();
        $plugins = [];
        foreach ($all_plugins_list AS $plugin_name) {
            if ($this->getIsEnabled($plugin_name) && $this->isProcessedHookPlugin($plugin_name, $hook_name)) {
                $plugins[$plugin_name] = $this->_getInstance($plugin_name);
            }
        }
        return $plugins;
    }

    /**
     * Вызов хука
     * передача данных для обработки их плагинами
     * данные передаются по ссылке
     * @param string $hook_name Имя хука
     * @param mixed $data Данные для манипуляции внутри плагина
     * @return PluginHook
     */
    public function hook($hook_name, &$data)
    {
        $hook_result = new PluginHook();
        $plugins = $this->_getActivePluginsByHookName($hook_name);

        /**
         * @var Plugin $plugin
         */
        foreach ($plugins AS $plugin_name => $plugin) {
            $break = false;
            try {
                $false_to_interrupt = $plugin->onHook($hook_name, $data);

                if ($false_to_interrupt === false) {
                    $break = true;
                }

                $hook_result->onSuccess($plugin_name, $break);
            } catch (\Exception $e) {
                $hook_result->onError($plugin_name, $e->getMessage());
            }

            if ($break) {
                break;
            }
        }

        return $hook_result;
    }


    /**
     * Возвращает имя класса модуля с пространством имен по имени модуля
     * @param string $name
     * @return string
     */
    protected function _getClassName($name)
    {
        return '\\Plugins\\' . $name . '\\Plugin';
    }

    /**
     * Возвращает тип пакета (plugin, theme, widget, module)
     * @return string
     */
    public function getType()
    {
        return 'plugin';
    }

    /**
     * Путь к директории с пакетами
     * @return string
     */
    public function getPackagesPath()
    {
        return H . '/sys/packages/Plugins';
    }
}