<?php
/**
 * Created by PhpStorm.
 * User: DES
 * Date: 20.09.2015
 * Time: 17:48
 */

namespace Dcms\System\Packages;

use Dcms\System\Core;
use Dcms\System\Packages\Models\ModuleMap;
use Dcms\System\Packages\Models\ModuleMapping;
use Dcms\System\Request;
use Dcms\System\Responses\Response;
use Dcms\System\Responses\ResponseHtml;
use Dcms\Ui\Html;
use Dcms\Ui\Page;
use Dcms\Ui\Ui;

class Modules extends Packages
{

    /**
     * Возвращает тип пакета (plugin, theme, widget, module)
     * @return string
     */
    public function getType()
    {
        return 'module';
    }

    /**
     * Возвращает имя класса модуля с пространством имен по имени модуля
     * @param string $name
     * @return string
     */
    protected function _getClassName($name)
    {
        return '\\Modules\\' . $name . '\\Module';
    }

    /**
     * @param string $name
     * @return Models\Module
     */
    protected function _getInstance($name)
    {
        return parent::_getInstance($name);
    }

    /**
     * @param string $name
     * @return ModuleMapping
     */
    protected function _getModuleMapping($name)
    {
        return new ModuleMapping($this->getConfig($name));
    }

    /**
     * Возвращает массив модулей, способных обработать запрос.
     * Массив возвращается в порядке релевантности
     * @param Request $request
     * @return ModuleMap[]
     */
    protected function _getMapsByRequest(Request $request)
    {
        $all_modules = $this->getList();
        $maps = [];
        foreach ($all_modules AS $module_name) {
            $mapping = $this->_getModuleMapping($module_name);
            $maps = array_merge($maps, $mapping->getMapsByRequest($request));
        }

        usort($maps, function (ModuleMap $a, ModuleMap $b) use ($request) {
            $index_a = $a->getCompareIndex($request);
            $index_b = $b->getCompareIndex($request);
            return ($index_a < $index_b) ? 1 : (($index_a > $index_b) ? -1 : 0);
        });

        return $maps;
    }

    /**
     * Выполнение запроса
     * @param Request $request
     * @return Ui|null
     * @throws \Exception
     */
    public function executeRequest(Request $request)
    {
        $maps = $this->_getMapsByRequest($request);

        foreach ($maps AS $map) {
            $module_instance = $this->_getInstance($map->getModuleName());
            $module_method = $map->getExecute();

            @ob_start(); // кэширование всех данных, которые будет возвращать модуль для обрамления в страницу

            $request->setPathVariables($map->getRequestPathVariables($request));
            // Непосредственно, вызов метода модуля
            $result = $module_instance->$module_method($request);
            $echo_content = @ob_get_clean();

            // если модуль вернул новый запрос, то обрабатываем его
            if ($result instanceof Request) {
                if ($result->getUrl()->getUrl() == $request->getUrl()->getUrl()) {
                    throw new \Exception(__("Модуль вернул переадресацию на себя"));
                }
                return $this->executeRequest($result);
            }

            // если модуль пытается тупо что то вывести в браузер (echo, print), то выводим это, обрамляя стандартной страницей
            if ($echo_content && $result) {
                throw new \Exception(__("Нельзя одновременно выводить и возвращать контент"));
            }

            if ($echo_content) {
                $result = new Ui([
                    "Items" => [
                        new Html($echo_content)
                    ]
                ]);
            }

            return $result;
        }
        Core::hook('Core:page_not_found', $request);

        return new ResponseHtml([
            "Status" => 404,
            "Content" => new Page([
                "Title" => __("Страница не найдена"),
                "Items" => [
                    new Html(__("Страница не найдена"))
                ]
            ])
        ]);
    }


    /**
     * Путь к директории с пакетами
     * @return string
     */
    public function getPackagesPath()
    {
        return H . '/sys/packages/Modules';
    }
}