<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 18:11
 */

namespace Dcms\System\Packages\Models;


use Dcms\System\Core;
use Dcms\System\SettingsProxy;

abstract class Package
{
    private $_settings = null;
    private $_type, $_name;

    final public function __construct($type, $name)
    {
        $this->_name = $name;
        $this->_type = $type;
    }

    final public function __destruct()
    {

    }

    /**
     * @return SettingsProxy
     */
    final public function getSettings()
    {
        if (is_null($this->_settings)) {
            $this->_settings = new SettingsProxy(Core::getSettings(), $this->_type . '-' . $this->_name);
        }
        return $this->_settings;
    }

    /**
     * Вызывается при установке
     * @return void
     */
    public function onInstalling()
    {

    }

    /**
     * Вызывается при включении
     * @return void
     */
    public function onEnabling()
    {

    }

    /**
     * Вызывается при отключении
     * @return void
     */
    public function onDisabling()
    {

    }

    /**
     * Вызывается при удалении
     * @return void
     */
    public function onRemoving()
    {

    }
}