<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 29.09.2015
 * Time: 19:21
 */

namespace Dcms\Helpers;


use Dcms\System\Core;

abstract class Text
{
    /**
     * Экранирование HTML при выводе.
     * Используется в основном для атрибутов HTML,
     * а также для экранирования всего, что только может вводиться вручную пользователем
     * @param string $string
     * @return string
     */
    public static function toValue($string)
    {
        return htmlspecialchars($string, ENT_QUOTES | ENT_HTML5, 'UTF-8', false);
    }

    /**
     * Форматирование текста перед выводом + экранирование HTML.
     * Используется для вывода комментов и другого содержимого.
     * @param string $string
     * @return string
     */
    public static function toOutput($string)
    {
        Core::hook('Text:toOutput', $string);
        return self::toValue($string);
    }

    /**
     * @param string $string
     * @param bool $exception_is_empty бросать исключение, если строка пуста
     * @return string|null
     * @throws \Exception
     */
    public static function toSave($string, $exception_is_empty = true)
    {
        Core::hook('Text:toSave', $string);

        if (!is_scalar($string)) {
            throw new \Exception(__('Ожидается скалярное значение'));
        }

        // явное приведение типа
        $string = (string)$string;

        // удаляем все управляющие символы
        $string = preg_replace('/\p{Cc}+/u', '', $string);
        // удаляем переносы вначале и конце строки
        $string = trim($string);

        if ($string === "") {
            $string = null;
        }

        if ($exception_is_empty && is_null($string)) {
            throw new \Exception(__('Пустая строка'));
        }

        return $string;
    }
}