<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 19.09.2015
 * Time: 15:11
 */

namespace Dcms\Helpers;


/**
 * Простой рендер PHP шаблонов
 * Class TemplateRender
 * @package Dcms\Helpers
 */
class TemplateRender
{
    protected $_assigned = array(); // переменные, которые будут переданы в шаблон

    public function clear()
    {
        $this->_assigned = array();
    }

    /**
     * Установка переменной в шаблон
     * @param string $name Ключ переменной
     * @param mixed $value Значение
     */
    public function assign($name, $value = null)
    {
        if (is_array($name)) {
            foreach ($name as $key => $value) {
                $this->assign($key, $value);
            }
            return;
        }
        if (is_scalar($name))
            $this->_assigned[$name] = $value;
    }

    /**
     * Получение обработанного шаблона
     * @param string $tpl_path Путь к файлу шаблона
     * @return string HTML код после обработки
     * @throws \Exception
     */
    public function render($tpl_path)
    {
        if (!file_exists($tpl_path)) {
            throw new \Exception(__("Файл шаблона (%s) не найден", basename($tpl_path)));
        }

        extract($this->_assigned);
        ob_start();
        @include $tpl_path;
        $content = ob_get_clean();
        return $content;
    }

    /**
     * выводим обработанный шаблон
     * @param string $tpl_file Путь к файлу шаблона или его имя, если указан dir_template
     */
    public function display($tpl_file)
    {
        echo $this->render($tpl_file);
    }
}