<?php
/**
 * Created by PhpStorm.
 * User: pavlovd
 * Date: 22.09.2015
 * Time: 18:11
 */

namespace Dcms\Helpers;

/**
 * Упрощение работы с файловой системой
 * Class FileSystem
 * @package Dcms\Helpers
 */
abstract class FileSystem
{

    /**
     * Возвращает путь к сайту относительно корневой папки сайта
     * Если движок установлен в корне ( http://example.com/ ), то вернет пустую строку.
     * Если движок установлен в подпапку ( http://example.com/site/ ), то вернет строку "/site"
     */
    public static function getSiteRelPath()
    {
        return self::getRelPath(H);
    }

    /**
     * Возвращает путь относительно корневой директории сайта.
     * Пригодится для получения url к файлу для клиента (браузера) по его пути в файловой системе.
     * !!! Не является противоположностью для метода getAbsPath, в случае, если движок установлен не в корневую директорию сайта
     * @param string $abs_path
     * @return string
     */
    public static function getRelPath($abs_path)
    {
        return str_replace(self::getUnixPath($_SERVER['DOCUMENT_ROOT']), '', self::getUnixPath($abs_path));
    }

    /**
     * Возвращает абсолютный путь к файлу (или папке) в файловой системе по пути, относительно папки с установленным движком.
     * !!! Не является противоположностью для метода getRelPath, в случае, если движок установлен не в корневую директорию сайта
     * @param string $rel_path
     * @return string
     */
    public static function getAbsPath($rel_path)
    {
        if ($rel_path{0} !== '/' && $rel_path{0} !== '\\') {
            $rel_path = '/' . $rel_path;
        }

        return H . self::getSystemPath($rel_path);
    }

    /**
     * Возвращает путь в unix стиле
     * @param $path
     * @return string
     */
    public static function getUnixPath($path)
    {
        return str_replace('\\', '/', $path);
    }

    /**
     * Возвращает путь в системном стиле
     * @param string $path
     * @return string
     */
    public static function getSystemPath($path)
    {
        return str_replace(array('\\', '/'), DIRECTORY_SEPARATOR, $path);
    }
}