<?php
/**
 * Created by PhpStorm.
 * User: Avenax
 * Date: 04.10.2018
 * Time: 16:11
 */

class avenax_pvp {

    public static $level_start = 10;


    public static function getListAllRooms($type = '1x1') {
        $db = self::connect();
        $query = $db->query('SELECT * FROM avenax_pvp_the_battle WHERE type_pvp = ?', [$type]);

        $result = $query->fetchAll(PDO::FETCH_ASSOC);
        $array = [];

        foreach ($result as $item) {
            if (isset($array[$item['id_battle']])) {
                $array[$item['id_battle']]['count'] += 1;
            } else {
                $array[$item['id_battle']]['id'] = $item['id'];
                $array[$item['id_battle']]['count'] = 1;
            }
        }
        return $array;
    }

    public static function getUser() {
        $db = self::connect();
        $user = $db->query('SELECT * FROM game_user WHERE id = ?', [$db->_string($_COOKIE['id'])]);
        return $user->fetch(PDO::FETCH_ASSOC);
    }

    public static function getRoom() {
        $db = self::connect();
        $query = $db->query('SELECT * FROM avenax_pvp_the_battle WHERE id_user = ?', [self::getIdUser()['id']]);
        return $query->fetch(PDO::FETCH_ASSOC);
    }

    public static function getUserEnemy() {
        $db = self::connect();
        $idBattle = self::getRoom()['id_battle'];
        $query = $db->query('SELECT id_user FROM avenax_pvp_the_battle WHERE id_user != ? AND id_battle = ?', [self::getIdUser()['id'], $idBattle]);
        $enemy = $db->query('SELECT vit, def, login FROM game_user WHERE id = ?', [$query->fetch(PDO::FETCH_ASSOC)['id_user']]);
        return $enemy->fetch(PDO::FETCH_ASSOC);
    }

    /**
     * 2 игрок готов и старт
     */
    public static function getLetsGo() {
        $db = self::connect();
        $id_battle = self::getRoom();
        $timeBattle = time() + (10 * 60) + 30;

        $allUser = $db->query('SELECT id_user FROM avenax_pvp_the_battle WHERE id_battle = ?' , [$id_battle['id_battle']]);

        $arrayUserId = $allUser->fetchAll(PDO::FETCH_COLUMN);

        $argc = [];
        $sql = $db->pdo->prepare('SELECT id, def,vit FROM game_user WHERE id = ?');

        foreach ($arrayUserId as $userId) {
            $sql->execute([$userId]);
            $argc[] = $sql->fetch(PDO::FETCH_ASSOC);
        }

        $sQuery = $db->pdo->prepare("UPDATE avenax_pvp_the_battle SET checkPrepare = ?, status_battle = ?, time_battle = ?, def = ?, vit = ? WHERE id_battle = ? AND id_user = ?");

        foreach ($argc as $value) {
            $sQuery->execute([1, 'battle', $timeBattle, $value['def'], $value['vit'], $id_battle['id_battle'], $value['id']]);
        }
        return $argc;
    }

    /**
     * Выборка комнаты
     * @return array
     */
    public static function getListRoom() {
        $db = self::connect();
        $query = $db->query('SELECT avenax_pvp_the_battle.*, users.login, users.level FROM avenax_pvp_the_battle, users WHERE avenax_pvp_the_battle.id_battle = ? AND avenax_pvp_the_battle.id_user = users.id', [self::getRoom()['id_battle']]);
        return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Выходим из комнаты
     * @param $idRoom
     */
    public static function getExitRoom($idRoom) {
        $db = self::connect();
        $db->query("DELETE FROM avenax_pvp_the_battle WHERE id = ? AND id_user = ?", [$idRoom, self::getUser()['id']]);
    }

    /**
     * Создаём новую комнату
     * @param $type
     */
    public static function getStartBattlePrepare($type = '1x1') {
        $db = self::connect();
        $db->query("INSERT INTO `avenax_pvp_the_battle` (`id_user`, `id_battle`,`type_pvp`, `status_battle`, `checkPrepare`) VALUES (?,?,?,?,?) ", [self::getIdUser()['id'], time(), $type, 'prepare', 1]);
    }

    /**
     * Присоединяемся к комнате
     * @param $id
     * @param string $type
     */
    public static function getJoinBattlePrepare($id, $type = '1x1') {
        $db = self::connect();
        $db->query("INSERT INTO `avenax_pvp_the_battle` (`id_user`, `id_battle`,`type_pvp`, `status_battle`, `checkPrepare`, `time_prepare`) VALUES (?,?,?,?,?,?) ", [self::getIdUser()['id'], $id, $type, 'prepare', 0, time() + 15]);
    }

    /**
     * Создал ли игрок комнату или нет
     * @return bool
     */
    public static function checkPrepareBattle($check = true) {
        $db = self::connect();
        $checkQuery = $db->query('SELECT status_battle, time_battle FROM avenax_pvp_the_battle WHERE id_user = ?', [self::getIdUser()['id']]);

        $status = $checkQuery->fetch(PDO::FETCH_ASSOC);

        $checkTime = $status['time_battle'] - time() - 30;
        if (!empty($status)) {
            if ($status['status_battle'] == 'prepare' || $check == false) {
                header('Location: room.php');
                exit();
            } else if ($status['status_battle'] == 'battle' && $checkTime < 10 * 60) {
                header('Location: battle.php');
                exit();
            }
        }
        return true;
    }

    public static function getTitleBattle() {
        $argc = self::getRoom();
        $title = null;
        if ($argc['type_pvp'] == '1x1') {
            $title = '<img src="https://wars.mobi/img/pvp/1x1.png" width="30" height="30" alt=""> Одиночный бой';
        } else if ($argc['type_pvp'] == '5x5') {
            $title = '<img src="https://wars.mobi/img/pvp/5x5.png" width="30" height="30" alt=""> Рейтинговый бой';
        } else {
            $title = '<img src="https://wars.mobi/img/pvp/8x8.png" width="30" height="30" alt=""> Массовый бой';
        }

        return $title;
    }

    public static function getPrepareTheBattle($room) {
        if ($room == true) {
            return '<font color="lime"> [Готов]</font>';
        }
        return '<font color="red"> [Не готов]</font>';
    }

    public static function checkLevel() {
        if (self::getUser()['lvl_user'] < self::$level_start) {
            $_SESSION['message'] = 'Вы не достигли ' . self::$level_start . ' уровня!';
            return false;
        }
        return true;
    }

    /**
     * Выборка ид игрока
     * @return mixed
     */
    private static function getIdUser() {
        $db = self::connect();
        $user = $db->query('SELECT * FROM game_user WHERE id = ?', [$db->_string($_COOKIE['id'])]);
        return $user->fetch(PDO::FETCH_ASSOC);
    }

    private static function connect() {
        $db = new Base();
        return $db;
    }
}