<?php

Flight::route('/', ['Home', 'index']);

Flight::route('/test', ['Home', 'test']);

Flight::route('/video/@url', ['Home', 'video'],
    function($url){
        $a = new Home();
        $a->video($url);
    }
);

Flight::route('/statistics', ['Home', 'statistics'],
    function(){
        $a = new Home();
        $a->statistics();
    }
);

Flight::route('/category/@url(/page/@page:[0-9]+)',
    ['Home', 'categories'], [$page = 1],
    function($url, $page){
        $a = new Home();
        $a->category($url, $page);
    }
);

Flight::route('/search(/page/@page:[0-9]+)',
    ['Home', 'search'], [$page = 1],
    function($page){
        $a = new Home();
        $a->search($page);
    }
);

Flight::route('/top(/@sort:[rating|views|down|new]+)(/page/@page:[0-9]+)',
    ['Home', 'top'], [$sort = 'rating', $page = 1],
    function($sort, $page){
        $a = new Home();
        $a->top($page);
    }
);

Flight::route('/download/mp4/@id:[0-9]+', ['Home', 'downmp4'],
    function($id){
        $a = new Home();
        $a->downmp4($id);
    }
);

Flight::route('/download/3gp/@id:[0-9]+', ['Home', 'down3gp'],
    function($id){
        $a = new Home();
        $a->down3gp($id);
    }
);

Flight::route('/view/@id:[0-9]+', ['Home', 'views'],
    function($id){
        $a = new Home();
        $a->views($id);
    }
);

//Обменник admin
Flight::route('/porno-obmenik-video/admin(/page/@page:[0-9]+)', ['FOAdmin', 'index'] , [$page = 1],
    function($page){
        $a = new FOAdmin();
        $a->index($page);
    });

Flight::route('/porno-obmenik-video/admin/@type:edit|del|add/@id:[0-9]+',
    ['FOAdmin', 'file_adm'], [$type = NULL, $id = 0],
    function($type, $id){
        $a = new FOAdmin();
        $a->file_adm($type, $id);
    }
);

Flight::route('/porno-obmenik-video/admin/@dey:moder_all|del_moder_all|clear_fo|clear_comm_fo|del_files_max180|del_files_min180',
    ['FOAdmin', 'dey'], [$dey = NULL],
    function($dey){
        $a = new FOAdmin();
        $a->dey($dey);
    }
);

Flight::route('/porno-obmenik-video/admin/settings', ['FOAdmin', 'settings']);

/* Обменник*/

Flight::route('/porno-obmenik-video/top(/@sort:[rating|views|down|new]+)(/page/@page:[0-9]+)',
    ['FO', 'top'], [$sort = 'rating', $page = 1],
    function($sort, $page){
        $a = new FO();
        $a->top($page);
    }
);

Flight::route('/porno-obmenik-video(/page/@page:[0-9]+)', ['FO', 'index'], [$page = 1],
    function ($page) {
        $a = new FO();
        $a->index($page);
    }
);

Flight::route('/porno-obmenik-video/upload', ['FO', 'upload']);

Flight::route('/porno-obmenik-video/@url(/page/@page:[0-9]+)', ['FO', 'video'], [$url = NULL, $page = 1],
    function($url, $page){
        $a = new FO();
        $a->video($url, $page);
    }
);

Flight::route('/porno-obmenik-video/download/@url', ['FO', 'download'],
    function($url){
        $a = new FO();
        $a->download($url);
    }
);

Flight::route('/porno-obmenik-video/online/@url', ['FO', 'online_fo'],
    function($url){
        $a = new FO();
        $a->online_fo($url);
    }
);



# admin panel routes

Flight::route('/admin', ['Admin', 'index']);
Flight::route('/admin/exit', ['Admin', 'exits']);

Flight::route('/admin/category', ['AdminCategory', 'index']);
Flight::route('/admin/category/add', ['AdminCategory', 'add']);
Flight::route('/admin/category/edit/@id:[0-9]+', ['AdminCategory', 'edit'],
    function($id){
        $a = new AdminCategory();
        $a->edit($id);
    }
);
Flight::route('/admin/category/del/@id:[0-9]+', ['AdminCategory', 'delete'],
    function($id){
        $a = new AdminCategory();
        $a->delete($id);
    }
);
Flight::route('/admin/category/up/@id:[0-9]+', ['AdminCategory', 'up'],
    function($id){
        $a = new AdminCategory();
        $a->up($id);
    }
);
Flight::route('/admin/category/down/@id:[0-9]+', ['AdminCategory', 'down'],
    function($id){
        $a = new AdminCategory();
        $a->down($id);
    }
);

Flight::route('/admin/upload', ['AdminFiles', 'upload']);
Flight::route('/admin/import', ['AdminFiles', 'import']);

Flight::route('/admin/manager(/page/@page:[0-9]+)',
    ['AdminManager', 'index'], [$page = 1],
    function($page){
        $a = new AdminManager();
        $a->index($page);
    }
);
Flight::route('/admin/manager/edit/@id:[0-9]+', ['AdminManager', 'edit'],
    function($id){
        $a = new AdminManager();
        $a->edit($id);
    }
);
Flight::route('/admin/manager/del/@id:[0-9]+', ['AdminManager', 'delete'],
    function($id){
        $a = new AdminManager();
        $a->delete($id);
    }
);
Flight::route('/sogl', function() {
$data = [
'title' => 'Соглашение',
'description' => '',
'keywords' => ''
];
Flight::view()->display('page/sogl.phtml', $data);
});
Flight::route('/sogl', function() {
Flight::view()->display('page/sogl.phtml');
});

Flight::route('/contact', function() {
$data = [
'title' => 'Связь с Администратором сайта PornoTV.su контакты',
'description' => '',
'keywords' => ''
];
Flight::view()->display('page/contact.phtml', $data);
});
Flight::route('/contact', function() {
Flight::view()->display('page/contact.phtml');
});
